<? include("include/apiWeb.php");?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Altius México</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    
    <!-- Custom CSS Mínimo -->
    <style>
        .text-gold { color: #c8a96e !important; }
        .bg-primary-blue { background-color: #1e3a5f !important; }
        .btn-gold {
            background-color: #c8a96e;
            border-color: #c8a96e;
            color: white;
        }
        .btn-gold:hover {
            background-color: #b8995e;
            border-color: #b8995e;
            color: white;
        }
        .hero-bg {
            background: linear-gradient(rgba(30, 58, 95, 0.8), rgba(30, 58, 95, 0.6)), 
                        url('img/img_principal.jpeg') center/cover;
        }
    </style>
</head>
<body>

    <? include("include/header.php");?>
    
<?php
// Recibir parámetro de URL
$idprop = isset($_GET['idprop']) ? (int)$_GET['idprop'] : 0;
$propiedad = getDetallePropiedad($apiData);


// Funciones para mostrar características según tipo
function obtenerTipoOperacion($cve) {
   $tipos = [1 => 'Venta', 2 => 'Renta', 3 => 'Renta Temporal'];
   return $tipos[$cve] ?? 'No especificado';
}



function mostrarCaracteristicas($propiedad) {
   $tipo = $propiedad['cve_inmoperaciontipo'];
   $html = '<div class="row g-3">';
   
   // Características comunes
   if (!empty($propiedad['mtrsuper'])) {
       $html .= '<div class="col-6 col-md-4">
                   <div class="d-flex align-items-center">
                       <i class="bi bi-arrows-fullscreen text-primary me-2"></i>
                       <div>
                           <small class="text-muted">Superficie</small>
                           <div class="fw-bold">' . $propiedad['mtrsuper'] . ' m²</div>
                       </div>
                   </div>
                 </div>';
   }
   
   // Solo para casas y departamentos (no terrenos)
   if ($tipo != 3) {
       if (!empty($propiedad['recamaras'])) {
           $html .= '<div class="col-6 col-md-4">
                       <div class="d-flex align-items-center">
                           <i class="bi bi-house text-primary me-2"></i>
                           <div>
                               <small class="text-muted">Recámaras</small>
                               <div class="fw-bold">' . $propiedad['recamaras'] . '</div>
                           </div>
                       </div>
                     </div>';
       }
       
       if (!empty($propiedad['banio'])) {
           $html .= '<div class="col-6 col-md-4">
                       <div class="d-flex align-items-center">
                           <i class="bi bi-droplet text-primary me-2"></i>
                           <div>
                               <small class="text-muted">Baños</small>
                               <div class="fw-bold">' . $propiedad['banio'] . '</div>
                           </div>
                       </div>
                     </div>';
       }
       
       if (!empty($propiedad['mtrconst'])) {
           $html .= '<div class="col-6 col-md-4">
                       <div class="d-flex align-items-center">
                           <i class="bi bi-building text-primary me-2"></i>
                           <div>
                               <small class="text-muted">Construcción</small>
                               <div class="fw-bold">' . $propiedad['mtrconst'] . ' m²</div>
                           </div>
                       </div>
                     </div>';
       }
   }
   
   if (!empty($propiedad['estacionamiento'])) {
       $html .= '<div class="col-6 col-md-4">
                   <div class="d-flex align-items-center">
                       <i class="bi bi-car-front text-primary me-2"></i>
                       <div>
                           <small class="text-muted">Estacionamiento</small>
                           <div class="fw-bold">' . $propiedad['estacionamiento'] . '</div>
                       </div>
                   </div>
                 </div>';
   }
   
   if (!empty($propiedad['antiguedad'])) {
       $html .= '<div class="col-6 col-md-4">
                   <div class="d-flex align-items-center">
                       <i class="bi bi-calendar text-primary me-2"></i>
                       <div>
                           <small class="text-muted">Antigüedad</small>
                           <div class="fw-bold">' . $propiedad['antiguedad'] . '</div>
                       </div>
                   </div>
                 </div>';
   }
   
   $html .= '</div>';
   return $html;
}

function mostrarAmenidades($amenidades) {
   if (empty($amenidades)) return '';
   
   $lista = explode("\n", trim($amenidades));
   $html = '<div class="row g-2">';
   
   foreach ($lista as $amenidad) {
       if (trim($amenidad)) {
           $html .= '<div class="col-6 col-md-4">
                       <div class="d-flex align-items-center">
                           <i class="bi bi-check-circle-fill text-success me-2"></i>
                           <span>' . trim(ucfirst($amenidad)) . '</span>
                       </div>
                     </div>';
       }
   }
   
   $html .= '</div>';
   return $html;
}
?>

<section class="py-5">
   <div class="container">
       <?php if ($idprop == 0): ?>
           <!-- Error: ID no válido -->
           <div class="row" style="margin-top:100px">
               <div class="col-12 text-center">
                   <div class="alert alert-danger">
                       <h4>Propiedad no encontrada</h4>
                       <p>El ID de propiedad no es válido o la propiedad no existe.</p>
                       <a href="propiedades.php" class="btn btn-primary">Ver todas las propiedades</a>
                   </div>
               </div>
           </div>
       <?php else: ?>
           <!-- Header de la propiedad -->
           <div class="row mb-4" style="margin-top:100px">
               <div class="col-12">
                   <nav aria-label="breadcrumb">
                       <ol class="breadcrumb">
                           <li class="breadcrumb-item"><a href="index.php">Inicio</a></li>
                           <li class="breadcrumb-item"><a href="propiedades.php">Propiedades</a></li>
                           <li class="breadcrumb-item active"><?= $propiedad['titulo'] ?></li>
                       </ol>
                   </nav>
                   
                   <div class="d-flex flex-column flex-md-row justify-content-between align-items-start mb-3">
                       <div>
                           <h1 class="display-6 fw-bold mb-2"><?= $propiedad['titulo'] ?></h1>
                           <p class="text-muted mb-3">
                               <i class="bi bi-geo-alt me-1"></i>
                               <?= $propiedad['direccion'] ?>
                           </p>
                       </div>
                       <div class="text-md-end">
                           <h2 class="text-gold mb-1"><?= $propiedad['preciodesc'] ?></h2>
                           <small class="text-muted"> $<?= number_format($propiedad['precio']) ?> <?= $propiedad['moneda'] ?></small>
                       </div>
                   </div>
                   
                   <!-- Badges informativos -->
                   <div class="d-flex flex-wrap gap-2 mb-4">
                       <span class="badge bg-primary fs-6"><?= obtenerTipoOperacion($propiedad['cve_inmoperacion']) ?></span>
                       <?php if ($propiedad['dest'] == 1): ?>
                           <span class="badge bg-warning fs-6">Destacada</span>
                       <?php endif; ?>
                       <?php if ($propiedad['stsventa'] == 0): ?>
                           <span class="badge bg-success fs-6">Disponible</span>
                       <?php else: ?>
                           <span class="badge bg-danger fs-6">Vendida</span>
                       <?php endif; ?>
                   </div>
               </div>
           </div>

           <!-- Galería de imágenes -->
          <div class="row mb-5">
            <div class="col-12">
                <div class="card border-0 shadow">
                    <div class="row g-0">
                        <!-- Imagen principal -->
                        <div class="col-md-8 pe-md-3">
                            <img src="https://www.negocio.me/inmuebles/inmuebles/th/<?php echo $propiedad['imagen'];?>" 
                                 class="img-fluid rounded-start" 
                                 alt="<?= htmlspecialchars($propiedad['titulo']) ?>" 
                                 style="height: 400px; width: 100%; object-fit: cover;">
                        </div>

                        <!-- Galería lateral -->
                        <div class="col-md-4">
                            <div class="row g-2 h-100 overflow-auto ps-md-2" style="max-height: 400px;">
                                <?php echo renderGaleriaProp($apiData); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


           <div class="row">
               <!-- Información principal -->
               <div class="col-lg-8">
                   <!-- Características -->
                   <div class="card border-0 shadow-sm mb-4">
                       <div class="card-body p-4">
                           <h3 class="fw-bold mb-4">
                               <i class="bi bi-house-check text-primary me-2"></i>Características
                           </h3>
                           <?= mostrarCaracteristicas($propiedad) ?>
                       </div>
                   </div>

                   <!-- Descripción -->
                   <div class="card border-0 shadow-sm mb-4">
                       <div class="card-body p-4">
                           <h3 class="fw-bold mb-3">
                               <i class="bi bi-file-text text-primary me-2"></i>Descripción
                           </h3>
                           <p class="lead"><?= nl2br($propiedad['descripcion']); ?></p>
                       </div>
                   </div>

                   <!-- Amenidades -->
                   <?php if (!empty($propiedad['amenidades'])): ?>
                   <div class="card border-0 shadow-sm mb-4">
                       <div class="card-body p-4">
                           <h3 class="fw-bold mb-4">
                               <i class="bi bi-star text-primary me-2"></i>Amenidades
                           </h3>
                           <?= mostrarAmenidades($propiedad['amenidades']) ?>
                       </div>
                   </div>
                   <?php endif; ?>

                   <!-- Cercanías -->
                   <?php if (!empty($propiedad['cercanias'])): ?>
                   <div class="card border-0 shadow-sm mb-4">
                       <div class="card-body p-4">
                           <h3 class="fw-bold mb-4">
                               <i class="bi bi-geo text-primary me-2"></i>Lugares de Interés
                           </h3>
                           <?= mostrarAmenidades($propiedad['cercanias']) ?>
                       </div>
                   </div>
                   <?php endif; ?>

                   <!-- Recorrido Virtual -->
                   <?php if (!empty($propiedad['if_recorrido'])): ?>
                   <div class="card border-0 shadow-sm mb-4">
                       <div class="card-body p-4">
                           <h3 class="fw-bold mb-3">
                               <i class="bi bi-camera-video text-primary me-2"></i>Recorrido Virtual
                           </h3>
                           <div class="ratio ratio-16x9">
                               <?= $propiedad['if_recorrido'] ?>
                           </div>
                       </div>
                   </div>
                   <?php endif; ?>

                   <!-- Video -->
                   <?php if (!empty($propiedad['if_video'])): ?>
                   <div class="card border-0 shadow-sm mb-4">
                       <div class="card-body p-4">
                           <h3 class="fw-bold mb-3">
                               <i class="bi bi-play-circle text-primary me-2"></i>Video de la Propiedad
                           </h3>
                           <div class="ratio ratio-16x9">
                               <?= $propiedad['if_video'] ?>
                           </div>
                       </div>
                   </div>
                   <?php endif; ?>

                   <!-- Mapa -->
                   <div class="card border-0 shadow-sm mb-4">
                       <div class="card-body p-4">
                           <h3 class="fw-bold mb-3">
                               <i class="bi bi-map text-primary me-2"></i>Ubicación
                           </h3>
                           <div class="ratio ratio-16x9">
                               <? echo $propiedad["mapa"];?>
                           </div>
                       </div>
                   </div>
               </div>

               <!-- Sidebar de contacto -->
               <div class="col-lg-4">
                   <div class="position-sticky" style="top: 100px;">
                       <!-- Contacto principal -->
                       <div class="card border-0 shadow-sm mb-4">
                           <div class="card-body p-4">
                               <h4 class="fw-bold mb-3 text-center">
                                   <i class="bi bi-headset text-primary me-2"></i>Contactar Asesor
                               </h4>
                               
                               <div class="d-grid gap-3 mb-4">
                                   <a href="https://wa.me/521<? echo $whatsapp;?>?text=Hola, me interesa la propiedad: <?= urlencode($propiedad['titulo']) ?>" 
                                      class="btn btn-success btn-lg">
                                       <i class="bi bi-whatsapp me-2"></i>WhatsApp
                                   </a>
                                   <a href="tel:<? echo $whatsapp;?>" class="btn btn-primary">
                                       <i class="bi bi-telephone me-2"></i>Llamar: <? echo $whatsapp;?>
                                   </a>
                                   <a href="mailto:<? echo $email;?>?subject=Consulta sobre: <?= urlencode($propiedad['titulo']) ?>" 
                                      class="btn btn-outline-primary">
                                       <i class="bi bi-envelope me-2"></i>Enviar Email
                                   </a>
                               </div>

                               <div class="border-top pt-3">
                                   <small class="text-muted">
                                       <i class="bi bi-shield-check me-1"></i>
                                       Respuesta garantizada en menos de 2 horas
                                   </small>
                               </div>
                           </div>
                       </div>

                       <!-- Formulario de consulta -->
                       <div class="card border-0 shadow-sm">
                           <div class="card-body p-4">
                               <h5 class="fw-bold mb-3">Solicitar Información</h5>
                    <form name="_jx_mn_form" id="_jx_mn_form" method="post">
                    <input type="hidden" name="x_d_fom" id="x_d_fom" value="FormSaveJS">
                    <input type="hidden" name="idksys" id="idksys" value="1655_Reconf_1655">
                    <input type="hidden" name="x_d_titulo" id="x_d_titulo" value="Info propiedad - May Mex Inmobiliaria">
<textarea name="idx_pers" id="idx_pers" style="font-size:12px;display:none;">
PROPIEDAD: <?= htmlspecialchars($propiedad['titulo']) ?>
</textarea>
                                   <div class="mb-3">
                                       <input type="text" id="bs_nombre" name="bs_nombre" class="form-control" placeholder="Nombre completo" required>
                                   </div>
                                   <div class="mb-3">
                                       <input type="email" id="bs_email" name="bs_email" class="form-control" placeholder="Email" required>
                                   </div>
                                   <div class="mb-3">
                                       <input type="tel" id="bs_telefono" name="bs_telefono" class="form-control" placeholder="Teléfono" required>
                                   </div>
                                   <div class="mb-3">
                                       <textarea class="form-control" id="bs_comentarios" name="bs_comentarios" rows="3" placeholder="Mensaje (opcional)"></textarea>
                                   </div>
                                   <input type="hidden" value="<?= $idprop ?>">
                                   <button type="submit" id="BtnEnviar" class="btn btn-gold w-100">
                                       <i class="bi bi-send me-2"></i>Enviar Consulta
                                   </button><span class="LoadForm"></span>
                               </form>
                           </div>
                       </div>
                   </div>
               </div>
           </div>

           <!-- Propiedades relacionadas -->
           <div class="row mt-5">
               <div class="col-12">
                   <h3 class="fw-bold mb-4">Propiedades Similares</h3>
                   <div class="row g-4">
                       <? echo renderRelacionadas($apiData);?>
                   </div>
               </div>
           </div>
       <?php endif; ?>
   </div>
</section>
    
   <? include("include/footer.php");?>
</body>
</html>