<?php
$xtoken = '1663_Reconf_1663_314WEBALTIUS';

if (isset($_GET['idprop']) && !empty($_GET['idprop'])) {
    $idprop = $_GET['idprop'];
} else {
    $idprop = null; // o un valor por defecto
    // Opcional: redirigir o mostrar error
}

$postData = [
  'xtoken' => $xtoken,
  'modulos' => ['configsys',
              'homedest','sliderprop',
              'propfull','detalleprop',
              'galeriaprop','proprelx'
          ],
  'idprop' => $idprop ?? 0
];

$ch = curl_init('https://www.crm.negocio.me/apiWeb/');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));


$response = curl_exec($ch);
curl_close($ch);

$apiData = [];
if ($response !== false) {
    $apiData = json_decode($response, true);
} else {
    echo '<p class="text-danger">Error al conectar con el API.</p>';
}

$confx = $apiData['configsys'] ?? [];
$whatsapp = $confx['telwhatsapp'] ?? 0;
$email = $confx['email'] ?? 0;

function renderHomedestCards($apiData) {
    if (!empty($apiData['homedest'])) {
        foreach ($apiData['homedest'] as $i => $prop) {
            $delay = ($i + 1) * 100;
            echo '
            <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="' . $delay . '">
                <div class="card border-0 shadow">
                    <div class="position-relative">
                        <img src="https://www.negocio.me/inmuebles/inmuebles/th/' . htmlspecialchars($prop['imagen']) . '" class="card-img-top" alt="' . htmlspecialchars($prop['titulo']) . '" style="height: 250px; object-fit: cover;">
                        <span class="badge bg-success position-absolute top-0 end-0 m-3">En Venta</span>
                    </div>
                    <div class="card-body">
                        <h5 class="card-title">' . htmlspecialchars($prop['titulo']) . '</h5>
                        <p class="text-muted mb-2"><i class="bi bi-geo-alt me-1"></i>' . htmlspecialchars($prop['ubicacion'] ?? '') . '</p>
                        <p class="h4 text-gold mb-3">' . htmlspecialchars($prop['preciodesc']).' $'.htmlspecialchars(number_format($prop['precio']) ?? 'Preguntar precio') . ' MXN</p>
                        <p class="small text-muted">' . htmlspecialchars($prop['frase_venta2'] ?? 'Consulta disponibilidad y precios') . '</p>
                        <a href="/detalles?idprop='.$prop['cve_inmpropiedad'].'&' . htmlspecialchars($prop['url']) . '" class="btn btn-outline-primary btn-sm mt-2">Ver Detalles</a>
                    </div>
                </div>
            </div>';
        }
    } else {
        echo '<p class="text-muted">No hay propiedades destacadas.</p>';
    }
}

function renderSliderProp($apiData) {
    if (!empty($apiData['sliderprop']) && !empty($apiData['sliderprop']['slides'])) {
        $slides = $apiData['sliderprop']['slides'];
        echo '<div id="propiedadesCarousel" class="carousel slide shadow rounded" data-bs-ride="carousel">';

        // Indicadores
        echo '<div class="carousel-indicators">';
        foreach ($slides as $index => $slide) {
            $activeClass = $index === 0 ? 'active' : '';
            echo '<button type="button" data-bs-target="#propiedadesCarousel" data-bs-slide-to="' . $index . '" class="' . $activeClass . '"></button>';
        }
        echo '</div>';

        // Slides
        echo '<div class="carousel-inner rounded">';
        foreach ($slides as $index => $slide) {
            $activeClass = $index === 0 ? 'active' : '';
            echo '<div class="carousel-item ' . $activeClass . '">
                    <img src="' . htmlspecialchars($slide['imagen']) . '" class="d-block w-100" alt="' . htmlspecialchars($slide['titulo']) . '" style="height: 400px; object-fit: cover;">
                    <div class="carousel-caption d-none d-md-block bg-dark bg-opacity-50 rounded p-3">
                        <h3 class="text-gold">' . htmlspecialchars($slide['titulo']) . '</h3>
                        <p class="mb-0">' . htmlspecialchars($slide['ubicacion']) . ' - Desde ' . htmlspecialchars($slide['preciodesc']) . '</p>
                    </div>
                  </div>';
        }
        echo '</div>';

        // Controles
        echo '<button class="carousel-control-prev" type="button" data-bs-target="#propiedadesCarousel" data-bs-slide="prev">
                <span class="carousel-control-prev-icon"></span>
              </button>';
        echo '<button class="carousel-control-next" type="button" data-bs-target="#propiedadesCarousel" data-bs-slide="next">
                <span class="carousel-control-next-icon"></span>
              </button>';

        echo '</div>';
    } else {
        echo '<p class="text-muted">No hay datos para el slider de propiedades.</p>';
    }
}

function renderPropFull($apiData) {
    if (!empty($apiData['propfull'])) {
        foreach (array_slice($apiData['propfull'], 0, 10) as $prop) {
            echo '<div class="col-lg-4 col-md-6">
                    <div class="card border-0 shadow h-100">
                        <div class="position-relative">
                            <img src="' . htmlspecialchars($prop['imagen']) . '" class="card-img-top" alt="' . htmlspecialchars($prop['titulo']) . '" style="height: 250px; object-fit: cover;">
                            <span class="badge bg-success position-absolute top-0 end-0 m-3">Disponible</span>
                        </div>
                        <div class="card-body p-4">
                            <h5 class="card-title fw-bold mb-2">' . htmlspecialchars($prop['titulo']) . '</h5>
                            <p class="text-muted mb-2">
                                <i class="bi bi-geo-alt me-1"></i>' . htmlspecialchars($prop['ubicacion']) . '
                            </p>
                            <div class="mb-3">';
            if (!empty($prop['recamaras'])) {
                echo '<span class="badge bg-light text-dark me-2"><i class="bi bi-house me-1"></i>' . intval($prop['recamaras']) . ' Rec</span>';
            }
            if (!empty($prop['banos'])) {
                echo '<span class="badge bg-light text-dark me-2"><i class="bi bi-droplet me-1"></i>' . intval($prop['banos']) . ' Baños</span>';
            }
            if (!empty($prop['metros'])) {
                echo '<span class="badge bg-light text-dark"><i class="bi bi-arrows-fullscreen me-1"></i>' . htmlspecialchars($prop['metros']) . ' m²</span>';
            }
            echo '</div>
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <div>
                                    <h4 class="text-gold mb-0">' . htmlspecialchars($prop['preciodesc']).' $'.number_format($prop['precio']) . ' <small class="text-muted">MXN</small></h4>
                                    
                                </div>
                                
                            </div>
                            <div class="d-grid gap-2">
                                <a href="/detalles?idprop='.$prop['cve_inmpropiedad'].'&' . htmlspecialchars($prop['url']) . '" class="btn btn-gold">
                                    Más Información
                                </a>
                                
                            </div>
                        </div>
                    </div>
                </div>';
        }
    } else {
        echo '<p class="text-muted">No hay propiedades disponibles.</p>';
    }
}

function getDetallePropiedad($apiData) {
    if (!empty($apiData['detalleprop'][0])) {
        $prop = $apiData['detalleprop'][0];

        return [
            'titulo' => $prop['titulo'] ?? 'juan',
            'descripcion' => $prop['descripcion'] ?? '',
            'precio' => $prop['precio'] ?? 0,
            'moneda' => $prop['moneda'] ?? 'MXN',
            'preciodesc' => $prop['preciodesc'] ?? '',
            'preciotrato' => $prop['preciotrato'] ?? '',
            'ciudad' => $prop['ciudad'] ?? '',
            'estado' => $prop['estado'] ?? '',
            'colonia' => $prop['colonia'] ?? '',
            'direccion' => $prop['direccion'] ?? '',
            'mtrconst' => $prop['mtrconst'] ?? '',
            'mtrsuper' => $prop['mtrsuper'] ?? '',
            'recamaras' => $prop['recamaras'] ?? '',
            'banio' => $prop['banio'] ?? '',
            'estacionamiento' => $prop['estacionamiento'] ?? '',
            'antiguedad' => $prop['antiguedad'] ?? '',
            'cve_inmoperacion' => $prop['cve_inmoperacion'] ?? 1,
            'cve_inmoperaciontipo' => $prop['cve_inmoperaciontipo'] ?? 1,
            'dest' => $prop['dest'] ?? 0,
            'stsventa' => $prop['stsventa'] ?? 0,
            'amenidades' => $prop['amenidades'] ?? '',
            'cercanias' => $prop['cercanias'] ?? '',
            'imagen' => $prop['imagen'] ?? '',
            'if_recorrido' => $prop['if_recorrido'] ?? '',
            'if_video' => $prop['if_video'] ?? '',
            'latitud' => $prop['latitud'] ?? '',
            'longitud' => $prop['longitud'] ?? '',
            'mapa' => $prop['mapa'] ?? ''
        ];
    }

  
    return null;
}

function renderGaleriaProp($apiData) {
    if (!empty($apiData['galeriaprop']) && is_array($apiData['galeriaprop'])) {
        foreach ($apiData['galeriaprop'] as $img) {
            // Si es string directa (valor simple como 'foto.jpg')
            if (is_string($img)) {
                $urlImg = 'https://www.negocio.me/inmuebles/galeria/' . htmlspecialchars($img);
            }
            // Si es array asociativo con clave 'imagen'
            elseif (is_array($img) && !empty($img['imagen'])) {
                $urlImg = 'https://www.negocio.me/inmuebles/inmuebles/th/' . htmlspecialchars($img['imagen']);
                $urlImgG = 'https://www.negocio.me/inmuebles/inmuebles/' . htmlspecialchars($img['imagen']);
            } else {
                continue;
            }

            echo '<div class="col-12 mb-2">';
            echo '  <img 
                        src="' . $urlImg . '" 
                        class="img-fluid rounded" 
                        style="height: 130px; width: 100%; object-fit: cover; cursor: pointer;" 
                        data-bs-toggle="modal" 
                        data-bs-target="#modalGaleriaUniversal" 
                        data-img="' . $urlImgG . '" 
                        alt="Foto de galería">';
            echo '</div>';
        }
    } else {
        echo '<p class="text-muted">No hay imágenes en la galería.</p>';
    }
}


function renderRelacionadas($apiData) {
    if (!empty($apiData['proprelx'])) {
        foreach (array_slice($apiData['proprelx'], 0, 3) as $prop) {
            echo '<div class="col-md-4">
                    <div class="card border-0 shadow-sm">
                        <img src="https://www.negocio.me/inmuebles/inmuebles/th/' . htmlspecialchars($prop['imagen']) . '" 
                             class="card-img-top" style="height: 200px; object-fit: cover;">
                        <div class="card-body">
                            <h6 class="card-title">' . htmlspecialchars($prop['titulo']) . '</h6>
                            <p class="text-muted small mb-2">' . htmlspecialchars($prop['direccion']) . '</p>
                            <h5 class="text-gold">' . htmlspecialchars($prop['preciodesc']) . ' $'.number_format($prop['precio']).'</h5>
                            <a href="detalles.php?idprop=' . intval($prop['cve_inmpropiedad']) . '" class="btn btn-outline-primary btn-sm">Ver Detalles</a>
                        </div>
                    </div>
                </div>';
        }
    } else {
        echo '<p class="text-muted">No hay propiedades relacionadas disponibles.</p>';
    }
}




