<? include("include/apiWeb.php"); ?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Altius México</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">

    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    <? include("include/css.php"); ?>
</head>

<body>

    <? include("include/header.php"); ?>


    <!-- Hero Section -->
    <section id="inicio" class="hero-bg d-flex align-items-center position-relative">
        <!-- Fondo oscuro sin video para mayor profesionalismo -->
        <div class="position-absolute top-0 start-0 w-100 h-100" style="background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%); z-index: 0;"></div>

        <div class="container py-5 position-relative" style="z-index: 1;">
            <div class="row align-items-center g-5">
                <!-- Columna Izquierda - Contenido Principal -->
                <div class="col-lg-7">
                    <!-- Badge Principal -->
                    <div class="mb-4" data-aos="fade-right">
                        <span class="badge text-white px-4 py-2 rounded-pill fs-6" style="background-color: #E53935;">
                            <i class="bi bi-building-check me-2"></i>
                            Expertos en inmuebles de Interés Social e Interés Medio
                        </span>
                    </div>

                    <!-- Título Principal -->
                    <h1 class="display-3 fw-bold text-white mb-4" data-aos="fade-right" data-aos-delay="100" style="text-shadow: 2px 4px 15px rgba(0,0,0,0.7);">
                        ALTIUS México
                    </h1>
                    <h2 class="h2 text-white mb-4" data-aos="fade-right" data-aos-delay="150" style="text-shadow: 1px 2px 10px rgba(0,0,0,0.6); color: #E53935 !important;">
                        TU CASA PROPIA CON INFONAVIT, FOVISSSTE, IFFAAM, CRÉDITO BANCARIO O RECURSOS PROPIOS
                    </h2>

                    <!-- Propuesta de Valor Simple -->
                    <p class="lead text-white mb-5" data-aos="fade-right" data-aos-delay="200" style="text-shadow: 1px 2px 8px rgba(0,0,0,0.5);">
                        Te acompañamos desde el inicio hasta las llaves • Todos los tipos de crédito • Proceso 100% seguro
                    </p>

                    <!-- CTA Principal -->
                    <div class="d-flex flex-column flex-sm-row gap-3 mb-4" data-aos="fade-right" data-aos-delay="250">
                        <a href="https://wa.me/5215514702610?text=Hola%20ALTIUS!%20Quiero%20información%20sobre%20casas%20con%20mi%20crédito%20INFONAVIT" target="_blank" class="btn btn-success btn-lg px-5 py-3 shadow-lg">
                            <i class="bi bi-whatsapp me-2"></i>WhatsApp Directo
                        </a>
                        <!-- <a href="#calculadora" class="btn btn-lg px-5 py-3 shadow-lg text-white" style="background-color: #E53935; border-color: #E53935;">
                            <i class="bi bi-calculator me-2"></i>Calcula tu Crédito
                        </a> -->
                    </div>

                    <!-- Trust Signals -->
                    <div class="d-flex flex-wrap gap-4 text-white" data-aos="fade-right" data-aos-delay="300">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-house-heart-fill me-2" style="color: #E53935;"></i>
                            <span>Zumpango • Tecámac • Tultitlán</span>
                        </div>
                        <div class="d-flex align-items-center">
                            <i class="bi bi-shield-check-fill me-2" style="color: #E53935;"></i>
                            <span>Proceso 100% Seguro</span>
                        </div>
                    </div>
                </div>

                <!-- Columna Derecha - Formulario Simplificado -->
                <div class="col-lg-5" data-aos="fade-left" data-aos-delay="200">
                    <div class="card border-0 shadow-lg" style="backdrop-filter: blur(10px); background: rgba(255, 255, 255, 0.98);">
                        <div class="card-body p-4">
                            <div class="text-center mb-4">
                                <h3 class="h4 fw-bold mb-2" style="color: #1a1a1a;">CONTÁCTANOS</h3>
                                <!-- <p class="text-muted small mb-0">Te respondemos en menos de 1 hora</p> -->
                            </div>

                            <form name="_jx_mn_form" id="_jx_mn_form" method="post">
                                <input type="hidden" name="x_d_fom" id="x_d_fom" value="FormSaveJS">
                                <input type="hidden" name="idksys" id="idksys" value="1663_Reconf_1663">
                                <input type="hidden" name="x_d_titulo" id="x_d_titulo" value="ALTIUS México - Contacto Hero">

                                <textarea name="idx_pers" id="idx_pers" style="font-size:12px;display:none;">
                                    Tipo de crédito: #fn_1#
                                    Zona de interés #fn_2#
                                </textarea>
                                <div class="mb-3">
                                    <input type="text" id="bs_nombre" name="bs_nombre" class="form-control form-control-lg" placeholder="Tu nombre completo" required>
                                </div>

                                <div class="mb-3">
                                    <input type="tel" id="bs_telefono" name="bs_telefono" class="form-control form-control-lg" placeholder="Tu WhatsApp (55 1234 5678)" required>
                                </div>

                                <div class="mb-3">
                                    <input type="email" id="bs_email" name="bs_email" class="form-control form-control-lg" placeholder="Email (contacto@altiusmexico.mx)" required>
                                </div>

                                <div class="mb-3">
                                    <select class="form-select form-select-lg" name="fn_1" required>
                                        <option value="">¿Qué crédito tienes?</option>
                                        <option value="INFONAVIT">INFONAVIT</option>
                                        <option value="FOVISSSTE">FOVISSSTE</option>
                                        <option value="ISFAAM">ISFAAM</option>
                                        <option value="Crédito Bancario">Crédito Bancario</option>
                                        <option value="Recursos Propios">Recursos Propios</option>
                                        <option value="No sé aún">No sé aún</option>
                                    </select>
                                </div>

                                <div class="mb-4">
                                    <select class="form-select form-select-lg" name="fn_2">
                                        <option value="">Zona de interés (opcional)</option>
                                        <option value="Zumpango">Zumpango</option>
                                        <option value="Tecámac">Tecámac</option>
                                        <option value="Tultitlán">Tultitlán</option>
                                        <option value="Huehuetoca">Huehuetoca</option>
                                        <option value="Cuautitlán México">Cuautitlán México</option>
                                        <option value="Cuautitlán Izcalli">Cuautitlán Izcalli</option>
                                        <option value="Cualquier zona">Cualquier zona</option>
                                    </select>
                                </div>

                                <button type="submit" id="BtnEnviar" class="btn btn-lg w-100 py-3 fw-bold text-white" style="background-color: #E53935; border-color: #E53935;">
                                    <i class="bi bi-send-fill me-2"></i>Recibir Asesoría Gratuita
                                </button>
                            </form>

                            <!-- Trust Badge Simple -->
                            <div class="text-center mt-3 pt-3 border-top">
                                <small class="text-muted">
                                    <i class="bi bi-shield-check me-1" style="color: #E53935;"></i>
                                    Sin compromiso • Te acompañamos hasta las llaves
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Servicios de Asesoría -->


    <!-- Estadísticas -->
    <section class="py-5 bg-light">
        <div class="container">
            <!-- Header Compacto -->
            <div class="text-center mb-4" data-aos="fade-up">
                <h2 class="fw-bold h3" style="color: #1a1a1a;">¿Por qué elegir ALTIUS?</h2>
                <p class="text-muted small">Tu inmobiliaria de confianza en el Estado de México</p>
            </div>

            <!-- Stats Cards - Diseño Horizontal -->
            <div class="row g-3 mb-4">
                <div class="col-6 col-md-3" data-aos="fade-up" data-aos-delay="100">
                    <div class="text-center">
                        <i class="bi bi-building-check fs-1" style="color: #E53935;"></i>
                        <h4 class="fw-bold mt-2 mb-0">6+</h4>
                        <small class="text-muted">Zonas disponibles</small>
                    </div>
                </div>

                <div class="col-6 col-md-3" data-aos="fade-up" data-aos-delay="200">
                    <div class="text-center">
                        <i class="bi bi-credit-card-2-front fs-1" style="color: #E53935;"></i>
                        <h4 class="fw-bold mt-2 mb-0">100%</h4>
                        <small class="text-muted">Tipos de crédito</small>
                    </div>
                </div>

                <div class="col-6 col-md-3" data-aos="fade-up" data-aos-delay="300">
                    <div class="text-center">
                        <i class="bi bi-shield-check fs-1" style="color: #E53935;"></i>
                        <h4 class="fw-bold mt-2 mb-0">Seguro</h4>
                        <small class="text-muted">Proceso garantizado</small>
                    </div>
                </div>

                <div class="col-6 col-md-3" data-aos="fade-up" data-aos-delay="400">
                    <div class="text-center">
                        <i class="bi bi-house-heart fs-1" style="color: #E53935;"></i>
                        <h4 class="fw-bold mt-2 mb-0">Llaves</h4>
                        <small class="text-muted">Te acompañamos</small>
                    </div>
                </div>
            </div>

            <!-- Proceso Simple - Cards Horizontales -->
            <div id="zonas" class="bg-white rounded-3 shadow-sm p-4 mb-4" data-aos="fade-up" data-aos-delay="500">
                <h3 class="h5 fw-bold mb-3 text-center" style="color: #1a1a1a;">Tu casa en 3 pasos simples</h3>
                <div class="row g-3">
                    <div class="col-md-4">
                        <div class="d-flex align-items-start">
                            <span class="badge rounded-circle me-3" style="background-color: #E53935; width: 30px; height: 30px; display: flex; align-items: center; justify-content: center;">1</span>
                            <div>
                                <h6 class="fw-semibold mb-1">Analizamos tu crédito</h6>
                                <small class="text-muted">INFONAVIT, FOVISSSTE o bancario</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="d-flex align-items-start">
                            <span class="badge rounded-circle me-3" style="background-color: #E53935; width: 30px; height: 30px; display: flex; align-items: center; justify-content: center;">2</span>
                            <div>
                                <h6 class="fw-semibold mb-1">Buscamos tu casa ideal</h6>
                                <small class="text-muted">En la zona que prefieras</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="d-flex align-items-start">
                            <span class="badge rounded-circle me-3" style="background-color: #E53935; width: 30px; height: 30px; display: flex; align-items: center; justify-content: center;">3</span>
                            <div>
                                <h6 class="fw-semibold mb-1">Tramitamos todo</h6>
                                <small class="text-muted">Hasta entregarte las llaves</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Zonas Disponibles - Grid Compacto -->
            <div class="row g-2 mb-4" data-aos="fade-up" data-aos-delay="600">
                <div class="col-12">
                    <h5 class="text-center mb-3 fw-semibold" style="color: #1a1a1a;">Zonas con disponibilidad inmediata</h5>
                </div>
                <div class="col-6 col-md-4 col-lg-2">
                    <div class="text-center p-2 bg-white rounded border">
                        <i class="bi bi-geo-alt-fill" style="color: #E53935;"></i>
                        <small class="d-block">Zumpango</small>
                    </div>
                </div>
                <div class="col-6 col-md-4 col-lg-2">
                    <div class="text-center p-2 bg-white rounded border">
                        <i class="bi bi-geo-alt-fill" style="color: #E53935;"></i>
                        <small class="d-block">Tecámac</small>
                    </div>
                </div>
                <div class="col-6 col-md-4 col-lg-2">
                    <div class="text-center p-2 bg-white rounded border">
                        <i class="bi bi-geo-alt-fill" style="color: #E53935;"></i>
                        <small class="d-block">Tultitlán</small>
                    </div>
                </div>
                <div class="col-6 col-md-4 col-lg-2">
                    <div class="text-center p-2 bg-white rounded border">
                        <i class="bi bi-geo-alt-fill" style="color: #E53935;"></i>
                        <small class="d-block">Huehuetoca</small>
                    </div>
                </div>
                <div class="col-6 col-md-4 col-lg-2">
                    <div class="text-center p-2 bg-white rounded border">
                        <i class="bi bi-geo-alt-fill" style="color: #E53935;"></i>
                        <small class="d-block">Cuautitlán Mex</small>
                    </div>
                </div>
                <div class="col-6 col-md-4 col-lg-2">
                    <div class="text-center p-2 bg-white rounded border">
                        <i class="bi bi-geo-alt-fill" style="color: #E53935;"></i>
                        <small class="d-block">Cuautitlán Izc</small>
                    </div>
                </div>
            </div>

            <!-- CTA Final Simple -->
            <div class="text-center" data-aos="fade-up" data-aos-delay="700">
                <p class="mb-3 fw-semibold">¿Tienes INFONAVIT o FOVISSSTE? Te ayudamos HOY</p>
                <a href="https://wa.me/5215514702610?text=Hola%20ALTIUS!%20Quiero%20información%20sobre%20casas%20disponibles"
                    target="_blank"
                    class="btn btn-lg text-white shadow"
                    style="background-color: #E53935; border-color: #E53935;">
                    <i class="bi bi-whatsapp me-2"></i>55 1470 2610 - Respuesta Inmediata
                </a>
                <p class="small text-muted mt-2 mb-0">
                    <i class="bi bi-check-circle me-1"></i>Sin compromiso • Asesoría gratuita
                </p>
            </div>
        </div>
    </section>

    <!-- Propiedades Destacadas -->
    <section id="propiedades" class="py-5 bg-white">
        <div class="container">
            <!-- Header Minimalista -->
            <div class="row mb-4">
                <div class="col-lg-12">
                    <div class="d-flex justify-content-between align-items-center flex-wrap" data-aos="fade-up">
                        <div>
                            <h2 class="h3 fw-bold mb-2" style="color: #1a1a1a;">
                                Casas Disponibles <span style="color: #E53935;">HOY</span>
                            </h2>
                            <p class="text-muted mb-0">Interés Social e interés Medio • Estado de México</p>
                        </div>
                        <div class="mt-3 mt-md-0">
                            <span class="badge bg-success px-3 py-2">
                                <i class="bi bi-check-circle me-1"></i>INFONAVIT / FOVISSSTE
                            </span>
                        </div>
                    </div>
                </div>
            </div>



            <!-- Barra de Info Rápida -->


            <!-- Properties Grid - RESPETANDO PHP -->
            <div class="row g-4 mb-4">
                <? echo renderHomedestCards($apiData); ?>
            </div>

            <!-- Sección de Confianza - Horizontal -->
            <div class="bg-light rounded p-4 mb-4" data-aos="fade-up">
                <div class="row g-3 align-items-center">
                    <div class="col-6 col-md-3 text-center">
                        <i class="bi bi-shield-check fs-3 mb-2" style="color: #E53935;"></i>
                        <h6 class="small fw-semibold mb-1">Proceso Seguro</h6>
                        <small class="text-muted d-none d-md-block">100% garantizado</small>
                    </div>
                    <div class="col-6 col-md-3 text-center">
                        <i class="bi bi-file-text fs-3 mb-2" style="color: #E53935;"></i>
                        <h6 class="small fw-semibold mb-1">Trámites Simples</h6>
                        <small class="text-muted d-none d-md-block">Nos encargamos</small>
                    </div>
                    <div class="col-6 col-md-3 text-center">
                        <i class="bi bi-credit-card fs-3 mb-2" style="color: #E53935;"></i>
                        <h6 class="small fw-semibold mb-1">Todos los Créditos</h6>
                        <small class="text-muted d-none d-md-block">Cualquier tipo de crédito</small>
                    </div>
                    <div class="col-6 col-md-3 text-center">
                        <i class="bi bi-key fs-3 mb-2" style="color: #E53935;"></i>
                        <h6 class="small fw-semibold mb-1">Hasta las Llaves</h6>
                        <small class="text-muted d-none d-md-block">Te acompañamos</small>
                    </div>
                </div>
            </div>

            <!-- CTA Flotante Mobile-First -->
            <div class="row">
                <div class="col-12">
                    <div class="card border-0 shadow" style="background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);">
                        <div class="card-body p-4 text-center text-white">
                            <h4 class="h5 fw-bold mb-3">¿No encuentras lo que buscas?</h4>
                            <p class="mb-3">Te ayudamos a encontrar la casa perfecta para tu presupuesto</p>
                            <div class="d-grid gap-2 d-md-block">
                                <a href="https://wa.me/5215514702610?text=Hola%20ALTIUS!%20Busco%20casa%20con%20mi%20crédito"
                                    target="_blank"
                                    class="btn btn-success btn-lg">
                                    <i class="bi bi-whatsapp me-2"></i>WhatsApp: 55 1470 2610
                                </a>
                                <a href="mailto:contacto@altiusmexico.mx"
                                    class="btn btn-outline-light btn-lg ms-md-2">
                                    <i class="bi bi-envelope me-2"></i>Email
                                </a>
                            </div>
                            <!-- <small class="d-block mt-3 text-white-50">
                                Lun-Sab 9AM-7PM • Respuesta inmediata
                            </small> -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Nuestro Enfoque -->
    <section id="nosotros" class="py-5 bg-white">
        <div class="container">
            <div class="row align-items-center g-4">
                <!-- Columna Principal - Diseño Card -->
                <div class="col-lg-7">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body p-4 p-md-5">
                            <!-- Header Compacto -->
                            <div class="d-inline-block mb-3">
                                <span class="badge text-white px-3 py-2" style="background-color: #E53935;">
                                    <i class="bi bi-building me-1"></i>ALTIUS MÉXICO
                                </span>
                            </div>

                            <h2 class="h3 fw-bold mb-3" style="color: #1a1a1a;">
                                Tu inmobiliaria de confianza en el Estado de México
                            </h2>

                            <p class="lead mb-4" style="color: #E53935; font-weight: 500;">
                                Somos expertos en vivienda de interés social e interés medio
                            </p>

                            <!-- Propuesta de Valor en Lista -->
                            <div class="mb-4">
                                <div class="d-flex align-items-start mb-3">
                                    <i class="bi bi-check-circle-fill me-3 mt-1" style="color: #E53935;"></i>
                                    <div>
                                        <strong>Te acompañamos de principio a fin</strong><br>
                                        <small class="text-muted">Desde la búsqueda hasta que tengas las llaves en tu mano</small>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="bi bi-check-circle-fill me-3 mt-1" style="color: #E53935;"></i>
                                    <div>
                                        <strong>Facilitamos todo el proceso</strong><br>
                                        <small class="text-muted">Nos ocupamos de todos los trámites y papeleos</small>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start">
                                    <i class="bi bi-check-circle-fill me-3 mt-1" style="color: #E53935;"></i>
                                    <div>
                                        <strong>Trabajamos con todos los créditos</strong><br>
                                        <small class="text-muted">INFONAVIT, FOVISSSTE, ISFAAM, Bancario o recursos propios</small>
                                    </div>
                                </div>
                            </div>

                            <!-- Quote destacado -->
                            <div class="bg-light rounded p-3 mb-4">
                                <p class="mb-0 fst-italic">
                                    <i class="bi bi-quote" style="color: #E53935;"></i>
                                    Una inmobiliaria no es solo la venta y compra de inmuebles, va mucho más allá...
                                    <strong>Se trata de un negocio de confianza</strong>, donde puedas ponerte en las manos
                                    de alguien profesional y desde el inicio sepas que todo va a salir
                                    <span style="color: #E53935; font-weight: bold;">"EXCELENTE"</span>
                                </p>
                            </div>

                            <!-- CTA Principal -->
                            <div class="d-grid gap-2 d-md-block">
                                <a href="https://wa.me/5215514702610?text=Hola%20ALTIUS!%20Quiero%20información%20sobre%20sus%20servicios"
                                    target="_blank"
                                    class="btn btn-lg text-white"
                                    style="background-color: #E53935;">
                                    <i class="bi bi-whatsapp me-2"></i>Contactar Ahora
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Columna Lateral - Info Rápida -->
                <div class="col-lg-5">
                    <!-- Card de Zonas -->
                    <div class="card border-0 bg-light mb-3">
                        <div class="card-body">
                            <h5 class="fw-bold mb-3" style="color: #1a1a1a;">
                                <i class="bi bi-geo-alt-fill me-2" style="color: #E53935;"></i>
                                Nuestras Zonas
                            </h5>
                            <div class="row g-2">
                                <div class="col-6">
                                    <div class="bg-white rounded p-2 text-center small">Zumpango</div>
                                </div>
                                <div class="col-6">
                                    <div class="bg-white rounded p-2 text-center small">Tecámac</div>
                                </div>
                                <div class="col-6">
                                    <div class="bg-white rounded p-2 text-center small">Tultitlán</div>
                                </div>
                                <div class="col-6">
                                    <div class="bg-white rounded p-2 text-center small">Huehuetoca</div>
                                </div>
                                <div class="col-6">
                                    <div class="bg-white rounded p-2 text-center small">Cuautitlán México</div>
                                </div>
                                <div class="col-6">
                                    <div class="bg-white rounded p-2 text-center small">Cuautitlán Izcalli</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Card de Contacto -->
                    <div class="card border-2" style="border-color: #E53935;">
                        <div class="card-body text-center">
                            <h5 class="fw-bold mb-3" style="color: #1a1a1a;">Contacto Directo</h5>

                            <div class="mb-3">
                                <i class="bi bi-person-circle fs-1 text-secondary mb-2"></i>
                                <!-- <h6 class="fw-semibold">Gustavo Sánchez</h6>
                                <small class="text-muted">Asesor Inmobiliario</small> -->
                            </div>

                            <div class="d-grid gap-2">
                                <a href="tel:5514702610" class="btn btn-outline-dark">
                                    <i class="bi bi-telephone-fill me-2"></i>55 1470 2610
                                </a>
                                <a href="mailto:contacto@altiusmexico.mx" class="btn btn-outline-dark">
                                    <i class="bi bi-envelope-fill me-2"></i>Email
                                </a>
                                <a href="https://www.altiusmexico.mx" target="_blank" class="btn btn-outline-dark">
                                    <i class="bi bi-globe me-2"></i>altiusmexico.mx
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Badge de Garantía -->
                    <div class="alert text-white text-center mt-3" style="background-color: #1a1a1a;">
                        <i class="bi bi-shield-check-fill me-2"></i>
                        <strong>Proceso 100% Seguro y Transparente</strong>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonios -->


    <!-- Contacto -->


    <? include("include/footer.php"); ?>
</body>

</html>