<? include("include/apiWeb.php");?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Altius México</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">

    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    
<? include("include/css.php");?>
</head>
<body>

    <? include("include/header.php");?>
    

    <!-- Hero Section -->
  <section id="inicio" class="position-relative" style="min-height: 100vh; padding-top: 100px;">
    <!-- Video Background -->
    <video autoplay muted loop class="position-absolute top-0 start-0 w-100 h-100 object-fit-cover" style="z-index: -1;">
        <source src="img/video.mp4" type="video/mp4">
    </video>
    
    <!-- Overlay con gradiente -->
    <div class="position-absolute top-0 start-0 w-100 h-100" style="background: linear-gradient(180deg, rgba(26,26,26,0.8) 0%, rgba(229,57,53,0.3) 100%); z-index: 0;"></div>
    
    <!-- Contenido Principal -->
    <div class="container position-relative" style="z-index: 1;">
        <!-- Header Top -->
        <div class="text-center mb-5" data-aos="fade-down">
            <img src="img/logo.png" alt="ALTIUS" height="80" class="mb-3 bg-white p-2 rounded shadow">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <h1 class="display-4 fw-bold text-white mb-3">
                        ALTIUS MÉXICO
                    </h1>
                    <div class="d-flex flex-wrap justify-content-center gap-3 mb-4">
                        <span class="badge bg-white text-dark px-3 py-2">
                            <i class="bi bi-geo-alt-fill text-danger me-1"></i>Zumpango
                        </span>
                        <span class="badge bg-white text-dark px-3 py-2">
                            <i class="bi bi-geo-alt-fill text-danger me-1"></i>Tecámac
                        </span>
                        <span class="badge bg-white text-dark px-3 py-2">
                            <i class="bi bi-geo-alt-fill text-danger me-1"></i>Tultitlán
                        </span>
                        <span class="badge bg-white text-dark px-3 py-2">
                            <i class="bi bi-geo-alt-fill text-danger me-1"></i>Huehuetoca
                        </span>
                        <span class="badge bg-white text-dark px-3 py-2">
                            <i class="bi bi-geo-alt-fill text-danger me-1"></i>Cuautitlán
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Contenido Central en 2 columnas -->
        <div class="row g-4 align-items-center">
            <!-- Columna Izquierda - Texto -->
            <div class="col-lg-6" data-aos="fade-right">
                <div class="bg-dark bg-opacity-50 p-4 rounded-3">
                    <h2 class="display-5 fw-bold text-white mb-3">
                        Tu casa con<br>
                        <span class="text-warning">INFONAVIT</span> o 
                        <span class="text-info">FOVISSSTE</span>
                    </h2>
                    <p class="text-white fs-5 mb-4">
                        Somos una inmobiliaria experta en bienes inmuebles de interés social e interés medio
                    </p>
                    
                    <!-- Features List -->
                    <div class="row g-3 mb-4">
                        <div class="col-6">
                            <div class="bg-white bg-opacity-10 rounded p-3 text-white">
                                <i class="bi bi-shield-check fs-4 d-block mb-2" style="color: #E53935;"></i>
                                <small>Proceso 100% Seguro</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="bg-white bg-opacity-10 rounded p-3 text-white">
                                <i class="bi bi-key fs-4 d-block mb-2" style="color: #E53935;"></i>
                                <small>Hasta las llaves</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="bg-white bg-opacity-10 rounded p-3 text-white">
                                <i class="bi bi-credit-card fs-4 d-block mb-2" style="color: #E53935;"></i>
                                <small>Todos los créditos</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="bg-white bg-opacity-10 rounded p-3 text-white">
                                <i class="bi bi-clock fs-4 d-block mb-2" style="color: #E53935;"></i>
                                <small>Respuesta rápida</small>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Direct Contact -->
                    <div class="border-top border-secondary pt-3">
                        <p class="text-white-50 small mb-2">Contacto directo:</p>
                        <h5 class="text-white fw-bold">Gustavo Sánchez</h5>
                        <a href="tel:5514702610" class="btn btn-outline-light btn-lg w-100">
                            <i class="bi bi-telephone-fill me-2"></i>55 1470 2610
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Columna Derecha - Formulario -->
            <div class="col-lg-6" data-aos="fade-left">
                <div class="card border-0 shadow-lg">
                    <div class="card-header text-white text-center py-3" style="background-color: #E53935;">
                        <h4 class="mb-0 fw-bold">Calcula tu crédito GRATIS</h4>
                    </div>
                    <div class="card-body p-4">
                        <form name="_jx_mn_form" id="_jx_mn_form" method="post">
                            <input type="hidden" name="x_d_fom" id="x_d_fom" value="FormSaveJS">
                            <input type="hidden" name="idksys" id="idksys" value="1655_Reconf_1655">
                            <input type="hidden" name="x_d_titulo" id="x_d_titulo" value="ALTIUS México - Hero Bootstrap">
                            
                            <div class="mb-3">
                                <label class="form-label small text-muted">Nombre completo</label>
                                <input type="text" id="bs_nombre" name="bs_nombre" class="form-control form-control-lg" required>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label small text-muted">WhatsApp</label>
                                <input type="tel" id="bs_telefono" name="bs_telefono" class="form-control form-control-lg" placeholder="55 1234 5678" required>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label small text-muted">Tipo de crédito</label>
                                <select class="form-select form-select-lg" name="tipo_credito" required>
                                    <option value="">Selecciona...</option>
                                    <option value="INFONAVIT">INFONAVIT</option>
                                    <option value="FOVISSSTE">FOVISSSTE</option>
                                    <option value="ISFAAM">ISFAAM</option>
                                    <option value="Bancario">Crédito Bancario</option>
                                    <option value="Recursos Propios">Recursos Propios</option>
                                    <option value="No sé">No sé aún</option>
                                </select>
                            </div>
                            
                            <div class="mb-4">
                                <label class="form-label small text-muted">Zona de interés</label>
                                <select class="form-select form-select-lg" name="zona_interes">
                                    <option value="">Cualquier zona</option>
                                    <option value="Zumpango">Zumpango</option>
                                    <option value="Tecámac">Tecámac</option>
                                    <option value="Tultitlán">Tultitlán</option>
                                    <option value="Huehuetoca">Huehuetoca</option>
                                    <option value="Cuautitlán México">Cuautitlán México</option>
                                    <option value="Cuautitlán Izcalli">Cuautitlán Izcalli</option>
                                </select>
                            </div>
                            
                            <button type="submit" id="BtnEnviar" class="btn btn-lg w-100 py-3 fw-bold text-white" style="background-color: #E53935;">
                                <i class="bi bi-send-fill me-2"></i>RECIBIR ASESORÍA
                            </button>
                        </form>
                        
                        <div class="text-center mt-3">
                            <small class="text-muted">
                                <i class="bi bi-shield-check me-1"></i>Sin compromiso • Te acompañamos hasta las llaves
                            </small>
                        </div>
                    </div>
                </div>
                
                <!-- WhatsApp Alternative -->
                <div class="text-center mt-3">
                    <a href="https://wa.me/5215514702610" target="_blank" class="btn btn-success btn-lg w-100">
                        <i class="bi bi-whatsapp me-2"></i>Prefiero WhatsApp
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Servicios de Asesoría -->
 

    <!-- Estadísticas -->
<section class="py-5 position-relative overflow-hidden" style="background: linear-gradient(180deg, #ffffff 0%, #f8f9fa 100%);">
    <!-- Patrón de fondo -->
    <div class="position-absolute top-0 start-0 w-100 h-100 opacity-10">
        <div class="position-absolute" style="top: -50px; left: -50px; width: 200px; height: 200px; border: 30px solid #E53935; border-radius: 50%; opacity: 0.1;"></div>
        <div class="position-absolute" style="bottom: -100px; right: -100px; width: 300px; height: 300px; border: 40px solid #E53935; border-radius: 50%; opacity: 0.1;"></div>
    </div>
    
    <div class="container position-relative">
        <!-- Header Lateral -->
        <div class="row mb-5">
            <div class="col-lg-3" data-aos="fade-right">
                <div class="border-start border-5 ps-3" style="border-color: #E53935 !important;">
                    <h2 class="display-6 fw-bold mb-0">ALTIUS</h2>
                    <p class="text-muted">La diferencia</p>
                </div>
            </div>
            <div class="col-lg-9" data-aos="fade-left">
                <div class="bg-dark text-white rounded-3 p-4">
                    <div class="row g-4 align-items-center">
                        <div class="col-md-3 text-center border-end">
                            <h3 class="fw-bold mb-0">TODOS</h3>
                            <small>los créditos</small>
                        </div>
                        <div class="col-md-3 text-center border-end">
                            <h3 class="fw-bold mb-0">6</h3>
                            <small>zonas activas</small>
                        </div>
                        <div class="col-md-3 text-center border-end">
                            <h3 class="fw-bold mb-0">100%</h3>
                            <small>seguro</small>
                        </div>
                        <div class="col-md-3 text-center">
                            <h3 class="fw-bold mb-0">1HR</h3>
                            <small>respuesta</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Proceso Timeline Vertical -->
        <div class="row mb-5">
            <div class="col-lg-12">
                <h3 class="text-center mb-4 fw-bold">Así de fácil es tener tu casa</h3>
                <div class="position-relative">
                    <!-- Línea vertical central -->
                    <div class="position-absolute start-50 translate-middle-x d-none d-md-block" style="width: 2px; height: 100%; background-color: #E53935; top: 0;"></div>
                    
                    <div class="row g-4">
                        <!-- Paso 1 -->
                        <div class="col-12" data-aos="fade-up">
                            <div class="row align-items-center">
                                <div class="col-md-5 text-md-end">
                                    <div class="card border-0 shadow-sm">
                                        <div class="card-body">
                                            <h5 class="fw-bold">Evaluamos tu situación</h5>
                                            <p class="text-muted mb-0 small">Analizamos qué crédito te conviene más</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2 text-center py-3">
                                    <div class="rounded-circle bg-danger text-white mx-auto d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                        <span class="fw-bold">1</span>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="d-flex gap-2">
                                        <span class="badge bg-light text-dark">INFONAVIT</span>
                                        <span class="badge bg-light text-dark">FOVISSSTE</span>
                                        <span class="badge bg-light text-dark">ISFAAM</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Paso 2 -->
                        <div class="col-12" data-aos="fade-up" data-aos-delay="100">
                            <div class="row align-items-center">
                                <div class="col-md-5 text-md-end order-md-2">
                                    <div class="card border-0 shadow-sm">
                                        <div class="card-body">
                                            <h5 class="fw-bold">Encontramos tu hogar</h5>
                                            <p class="text-muted mb-0 small">En la zona que más te convenga</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2 text-center py-3 order-md-1">
                                    <div class="rounded-circle bg-danger text-white mx-auto d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                        <span class="fw-bold">2</span>
                                    </div>
                                </div>
                                <div class="col-md-5 order-md-3">
                                    <div class="text-muted small">
                                        <i class="bi bi-check2 text-success"></i> Visitas programadas<br>
                                        <i class="bi bi-check2 text-success"></i> Comparación de opciones<br>
                                        <i class="bi bi-check2 text-success"></i> Asesoría completa
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Paso 3 -->
                        <div class="col-12" data-aos="fade-up" data-aos-delay="200">
                            <div class="row align-items-center">
                                <div class="col-md-5 text-md-end">
                                    <div class="card border-0 shadow-sm">
                                        <div class="card-body">
                                            <h5 class="fw-bold">Gestionamos todo</h5>
                                            <p class="text-muted mb-0 small">Nos encargamos de todos los trámites</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2 text-center py-3">
                                    <div class="rounded-circle bg-danger text-white mx-auto d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                        <span class="fw-bold">3</span>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="alert alert-success mb-0 small">
                                        <i class="bi bi-key-fill me-2"></i>
                                        <strong>¡Llaves en mano!</strong>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Mapa de Zonas Creativo -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="card border-0 shadow" style="background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);">
                    <div class="card-body p-5">
                        <h4 class="text-white text-center mb-4">
                            <i class="bi bi-map me-2"></i>Cobertura Estado de México
                        </h4>
                        <div class="row g-3 justify-content-center">
                            <div class="col-6 col-md-4">
                                <button class="btn btn-outline-light w-100 py-3">
                                    <i class="bi bi-pin-map-fill d-block fs-3 mb-2" style="color: #E53935;"></i>
                                    Zumpango
                                </button>
                            </div>
                            <div class="col-6 col-md-4">
                                <button class="btn btn-outline-light w-100 py-3">
                                    <i class="bi bi-pin-map-fill d-block fs-3 mb-2" style="color: #E53935;"></i>
                                    Tecámac
                                </button>
                            </div>
                            <div class="col-6 col-md-4">
                                <button class="btn btn-outline-light w-100 py-3">
                                    <i class="bi bi-pin-map-fill d-block fs-3 mb-2" style="color: #E53935;"></i>
                                    Tultitlán
                                </button>
                            </div>
                            <div class="col-6 col-md-4">
                                <button class="btn btn-outline-light w-100 py-3">
                                    <i class="bi bi-pin-map-fill d-block fs-3 mb-2" style="color: #E53935;"></i>
                                    Huehuetoca
                                </button>
                            </div>
                            <div class="col-6 col-md-4">
                                <button class="btn btn-outline-light w-100 py-3">
                                    <i class="bi bi-pin-map-fill d-block fs-3 mb-2" style="color: #E53935;"></i>
                                    Cuautitlán
                                </button>
                            </div>
                            <div class="col-6 col-md-4">
                                <button class="btn btn-outline-light w-100 py-3">
                                    <i class="bi bi-pin-map-fill d-block fs-3 mb-2" style="color: #E53935;"></i>
                                    + Zonas
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- CTA Creativo -->
        <div class="row">
            <div class="col-lg-8 mx-auto text-center" data-aos="zoom-in">
                <div class="position-relative">
                    <div class="bg-white rounded-pill shadow-lg p-4">
                        <div class="row align-items-center">
                            <div class="col-md-7">
                                <h4 class="fw-bold mb-0">¿Listo para tu casa propia?</h4>
                                <p class="text-muted mb-0 small">Con tu crédito INFONAVIT o FOVISSSTE</p>
                            </div>
                            <div class="col-md-5 mt-3 mt-md-0">
                                <a href="https://wa.me/5215514702610" target="_blank" class="btn btn-lg btn-success rounded-pill px-4">
                                    <i class="bi bi-whatsapp me-2"></i>¡Empezar!
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

    <!-- Propiedades Destacadas -->
  <section id="propiedades" class="py-5 bg-white">
    <div class="container">
        <!-- Header Minimalista -->
        <div class="row mb-4">
            <div class="col-lg-12">
                <div class="d-flex justify-content-between align-items-center flex-wrap" data-aos="fade-up">
                    <div>
                        <h2 class="h3 fw-bold mb-2" style="color: #1a1a1a;">
                            Casas Disponibles <span style="color: #E53935;">HOY</span>
                        </h2>
                        <p class="text-muted mb-0">Interés Social y Medio • Estado de México</p>
                    </div>
                    <div class="mt-3 mt-md-0">
                        <span class="badge bg-success px-3 py-2">
                            <i class="bi bi-check-circle me-1"></i>INFONAVIT / FOVISSSTE
                        </span>
                    </div>
                </div>
            </div>
        </div>

       

        <!-- Barra de Info Rápida -->
        

        <!-- Properties Grid - RESPETANDO PHP -->
        <div class="row g-4 mb-4">
            <? echo renderHomedestCards($apiData);?>
        </div>

        <!-- Sección de Confianza - Horizontal -->
        <div class="bg-light rounded p-4 mb-4" data-aos="fade-up">
            <div class="row g-3 align-items-center">
                <div class="col-6 col-md-3 text-center">
                    <i class="bi bi-shield-check fs-3 mb-2" style="color: #E53935;"></i>
                    <h6 class="small fw-semibold mb-1">Proceso Seguro</h6>
                    <small class="text-muted d-none d-md-block">100% garantizado</small>
                </div>
                <div class="col-6 col-md-3 text-center">
                    <i class="bi bi-file-text fs-3 mb-2" style="color: #E53935;"></i>
                    <h6 class="small fw-semibold mb-1">Trámites Simples</h6>
                    <small class="text-muted d-none d-md-block">Nos encargamos</small>
                </div>
                <div class="col-6 col-md-3 text-center">
                    <i class="bi bi-credit-card fs-3 mb-2" style="color: #E53935;"></i>
                    <h6 class="small fw-semibold mb-1">Todos los Créditos</h6>
                    <small class="text-muted d-none d-md-block">INFONAVIT y más</small>
                </div>
                <div class="col-6 col-md-3 text-center">
                    <i class="bi bi-key fs-3 mb-2" style="color: #E53935;"></i>
                    <h6 class="small fw-semibold mb-1">Hasta las Llaves</h6>
                    <small class="text-muted d-none d-md-block">Te acompañamos</small>
                </div>
            </div>
        </div>

        <!-- CTA Flotante Mobile-First -->
        <div class="row">
            <div class="col-12">
                <div class="card border-0 shadow" style="background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);">
                    <div class="card-body p-4 text-center text-white">
                        <h4 class="h5 fw-bold mb-3">¿No encuentras lo que buscas?</h4>
                        <p class="mb-3">Te ayudamos a encontrar la casa perfecta para tu presupuesto</p>
                        <div class="d-grid gap-2 d-md-block">
                            <a href="https://wa.me/5215514702610?text=Hola%20ALTIUS!%20Busco%20casa%20con%20mi%20crédito" 
                               target="_blank" 
                               class="btn btn-success btn-lg">
                                <i class="bi bi-whatsapp me-2"></i>WhatsApp: 55 1470 2610
                            </a>
                            <a href="mailto:contacto@altiusmexico.mx" 
                               class="btn btn-outline-light btn-lg ms-md-2">
                                <i class="bi bi-envelope me-2"></i>Email
                            </a>
                        </div>
                        <small class="d-block mt-3 text-white-50">
                            Lun-Sab 9AM-7PM • Respuesta inmediata
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

    <!-- Nuestro Enfoque -->
  <section id="nosotros" class="py-5 position-relative overflow-hidden">
    <!-- Fondo con gradiente dinámico -->
    <div class="position-absolute top-0 start-0 w-100 h-100" style="background: linear-gradient(135deg, #fff 0%, rgba(229,57,53,0.05) 100%); z-index: -1;"></div>
    
    <div class="container-fluid px-0">
        <!-- Hero Banner Full Width -->
        <div class="bg-dark text-white py-5 mb-5">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-8">
                        <h2 class="display-4 fw-bold mb-3" data-aos="fade-right">
                            ALTIUS <span style="color: #E53935;">MÉXICO</span>
                        </h2>
                        <p class="fs-5 mb-0" data-aos="fade-right" data-aos-delay="100">
                            Capitalización Subcuenta de Vivienda
                        </p>
                    </div>
                    <div class="col-lg-4 text-lg-end mt-3 mt-lg-0">
                        <div class="badge bg-danger px-4 py-3 fs-6" data-aos="zoom-in">
                            <i class="bi bi-award-fill me-2"></i>Inmobiliaria de Confianza
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container">
            <!-- Sección Principal Split Screen -->
            <div class="row g-5 mb-5">
                <!-- Lado Izquierdo - Historia -->
                <div class="col-lg-6" data-aos="fade-up">
                    <div class="position-sticky" style="top: 100px;">
                        <div class="mb-4">
                            <span class="text-uppercase text-muted small fw-bold">NUESTRA MISIÓN</span>
                            <h3 class="display-6 fw-bold mt-2" style="color: #1a1a1a;">
                                Hacemos realidad el sueño de tu casa propia
                            </h3>
                        </div>
                        
                        <!-- Quote destacado con diseño diferente -->
                        <div class="position-relative ps-4 mb-4">
                            <div class="position-absolute start-0 top-0 bottom-0" style="width: 4px; background-color: #E53935;"></div>
                            <p class="fs-5 fw-light mb-0">
                                "Una inmobiliaria no es solo la venta y compra de inmuebles, 
                                <strong>se trata de un negocio de confianza</strong>"
                            </p>
                            <footer class="mt-2 text-muted">— Gustavo Sánchez, Director</footer>
                        </div>
                        
                        <!-- Valores en diseño horizontal -->
                        <div class="bg-light rounded-3 p-4">
                            <h5 class="fw-bold mb-3">Nuestro Compromiso</h5>
                            <div class="d-flex align-items-center mb-2">
                                <div class="rounded-circle bg-danger text-white p-2 me-3" style="width: 40px; height: 40px;">
                                    <i class="bi bi-1-circle-fill"></i>
                                </div>
                                <span>Te acompañamos desde el inicio</span>
                            </div>
                            <div class="d-flex align-items-center mb-2">
                                <div class="rounded-circle bg-danger text-white p-2 me-3" style="width: 40px; height: 40px;">
                                    <i class="bi bi-2-circle-fill"></i>
                                </div>
                                <span>Facilitamos todos los trámites</span>
                            </div>
                            <div class="d-flex align-items-center">
                                <div class="rounded-circle bg-danger text-white p-2 me-3" style="width: 40px; height: 40px;">
                                    <i class="bi bi-3-circle-fill"></i>
                                </div>
                                <span>Hasta entregarte las llaves</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Lado Derecho - Info Dinámica -->
                <div class="col-lg-6">
                    <!-- Créditos Disponibles -->
                    <div class="mb-4" data-aos="fade-left">
                        <h4 class="fw-bold mb-3">Trabajamos con TODOS los créditos</h4>
                        <div class="row g-2">
                            <div class="col-6">
                                <div class="card border-0 bg-success text-white">
                                    <div class="card-body text-center py-3">
                                        <i class="bi bi-check-lg fs-3 d-block mb-2"></i>
                                        <strong>INFONAVIT</strong>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="card border-0 bg-info text-white">
                                    <div class="card-body text-center py-3">
                                        <i class="bi bi-check-lg fs-3 d-block mb-2"></i>
                                        <strong>FOVISSSTE</strong>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="card border-0 bg-warning text-dark">
                                    <div class="card-body text-center py-3">
                                        <i class="bi bi-check-lg fs-3 d-block mb-2"></i>
                                        <strong>ISFAAM</strong>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="card border-0 bg-primary text-white">
                                    <div class="card-body text-center py-3">
                                        <i class="bi bi-check-lg fs-3 d-block mb-2"></i>
                                        <strong>BANCARIO</strong>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Mapa Visual de Zonas -->
                    <div class="mb-4" data-aos="fade-left" data-aos-delay="100">
                        <h4 class="fw-bold mb-3">Presencia en Estado de México</h4>
                        <div class="position-relative p-4 bg-light rounded-3">
                            <div class="row g-2">
                                <div class="col-4 text-center">
                                    <i class="bi bi-geo-alt-fill fs-2" style="color: #E53935;"></i>
                                    <small class="d-block">Zumpango</small>
                                </div>
                                <div class="col-4 text-center">
                                    <i class="bi bi-geo-alt-fill fs-2" style="color: #E53935;"></i>
                                    <small class="d-block">Tecámac</small>
                                </div>
                                <div class="col-4 text-center">
                                    <i class="bi bi-geo-alt-fill fs-2" style="color: #E53935;"></i>
                                    <small class="d-block">Tultitlán</small>
                                </div>
                                <div class="col-4 text-center">
                                    <i class="bi bi-geo-alt-fill fs-2" style="color: #E53935;"></i>
                                    <small class="d-block">Huehuetoca</small>
                                </div>
                                <div class="col-4 text-center">
                                    <i class="bi bi-geo-alt-fill fs-2" style="color: #E53935;"></i>
                                    <small class="d-block">Cuautitlán</small>
                                </div>
                                <div class="col-4 text-center">
                                    <i class="bi bi-geo-alt-fill fs-2" style="color: #E53935;"></i>
                                    <small class="d-block">+ Zonas</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Contacto Card Flotante -->
                    
                </div>
            </div>
            
            <!-- Bottom CTA Full Width -->
            <div class="text-center py-5 bg-light rounded-3" data-aos="fade-up">
                <h3 class="fw-bold mb-3">Ponte en nuestras manos para comprar tu inmueble</h3>
                <p class="text-muted mb-4">Proceso 100% Seguro y Transparente</p>
                <a href="#contacto" class="btn btn-dark btn-lg px-5 rounded-pill">
                    Comenzar mi proceso <i class="bi bi-arrow-right ms-2"></i>
                </a>
            </div>
        </div>
    </div>
</section>

   <? include("include/footer.php");?>
</body>
</html>