<style>
    .text-gold { 
        color: #E53935 !important; /* Rojo ALTIUS del logo - coherencia de marca */
    }
    .bg-primary-blue { 
        background-color: #1a1a1a !important; /* MANTENER - funciona bien con logo negro */
    }
    .btn-gold {
        background-color: #E53935; /* Rojo principal ALTIUS para CTAs */
        border-color: #E53935;
        color: white;
        transition: all 0.3s ease;
    }
    .btn-gold:hover {
        background-color: #C62828; /* Rojo más oscuro - mantiene jerarquía */
        border-color: #C62828;
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(229, 57, 53, 0.3); /* Sombra ajustada al rojo ALTIUS */
    }
        
.hero-bg {
    position: relative;
    overflow: hidden;
    min-height: 100vh;
    padding-top: 120px;
}
.hero-bg::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: radial-gradient(circle at 50% 50%, rgba(229, 57, 53, 0.03) 0%, transparent 70%); /* Gradiente con rojo ALTIUS */
    pointer-events: none;
}
    
    .hero-title {
        font-size: 4.5rem;
        font-weight: 800;
        line-height: 1.1;
        text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.3);
    }
    .hero-subtitle {
        font-size: 1.4rem;
        font-weight: 300;
        line-height: 1.6;
        text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.2);
    }
    
    .floating-badge {
        animation: float 3s ease-in-out infinite;
        background: rgba(255, 255, 255, 0.08);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(229, 57, 53, 0.2); /* Borde rojo ALTIUS sutil */
    }
    @keyframes float {
        0%, 100% { transform: translateY(0px); }
        50% { transform: translateY(-10px); }
    }
    
    .stats-card {
        background: rgba(255, 255, 255, 0.05);
        backdrop-filter: blur(15px);
        border: 1px solid rgba(255, 255, 255, 0.1);
        transition: all 0.3s ease;
    }
    .stats-card:hover {
        background: rgba(255, 255, 255, 0.1);
        transform: translateY(-5px);
        border: 1px solid rgba(229, 57, 53, 0.3); /* Borde rojo ALTIUS en hover */
    }
    
    /* Media queries responsive mejorados */
    @media (max-width: 768px) {
        .hero-bg {
            padding-top: 140px;
            min-height: 100vh;
        }
        .hero-title { 
            font-size: 2.5rem; 
            line-height: 1.2;
        }
        .hero-subtitle { 
            font-size: 1rem; 
            line-height: 1.5;
        }
        .floating-badge {
            font-size: 0.85rem;
            padding: 0.5rem 1rem !important;
        }
        .btn-lg {
            font-size: 0.9rem;
            padding: 0.75rem 1.5rem !important;
        }
        .stats-card {
            margin-bottom: 1rem;
            padding: 1rem !important;
        }
        .gap-4 {
            gap: 0.5rem !important;
        }
        .d-flex.flex-wrap > div {
            flex: 0 0 100%;
            justify-content: center;
            margin-bottom: 0.5rem;
        }
    }
    
    @media (max-width: 576px) {
        .hero-bg {
            padding-top: 130px;
        }
        .hero-title { 
            font-size: 2rem; 
        }
        .hero-subtitle { 
            font-size: 0.9rem; 
        }
        .btn-lg {
            font-size: 0.8rem;
            padding: 0.6rem 1.2rem !important;
            margin-bottom: 0.5rem;
        }
        .me-3 {
            margin-right: 0 !important;
            margin-bottom: 0.5rem;
        }
    }
</style>