<?php
session_start();
include("../include/BDQuery.php");

// error_reporting(E_ALL);
// ini_set('display_errors', 1);

function addcarrito($link, $fecha_sys, $idcli, $session, $idprod, $cant, $addicional, $color)
{
	// Acepta $link o usa $mysqli global
	// global $mysqli;
	// $link = ($link instanceof mysqli) ? $link : (isset($mysqli) ? $mysqli : null);
	// if (!$link) {
	// 	return 'Error de conexión';
	// }

	// Normaliza/asegura entradas
	$idCliente   = isset($_SESSION["_IDU_R"]) ? (string)$_SESSION["_IDU_R"] : '';
	$tiendaProv  = isset($_SESSION["_CVE_TPROV"]) ? (string)$_SESSION["_CVE_TPROV"] : '';
	$tipoPrecio  = isset($_SESSION["_IDREG_IDTIPOPRECIO_"]) ? (int)$_SESSION["_IDREG_IDTIPOPRECIO_"] : 1;
	$ivaCiudad   = isset($_SESSION["_IVACIUDAD_"]) ? (float)$_SESSION["_IVACIUDAD_"] : 0.0;


	$idprod      = (int)$idprod;
	$cant        = (int)$cant;
	if ($cant <= 0) {
		$cant = 1;
	}
	$addicional  = trim($addicional ?? "0");
	$color = trim($color ?? "0");

	$msj = 'Error inesperado';

	// Inicia transacción
	$link->begin_transaction();

	try {
		// 1) Si no existe _SESSIONCARRITO_, crea carrito
		if (empty($_SESSION["_SESSIONCARRITO_"])) {
			$desc = 'Carrito 2025 ' . $fecha_sys;

			$sqlInsCar = "INSERT INTO carrito
                (cve_statuscat, fecha_sys, cve_sysusuario, cve_registro, descripcion, session, cerrado, cve_tiendaprovedor, tinsert)
                VALUES (2, ?, ?, ?, ?, ?, 0, ?, 0)";
			$stmt = $link->prepare($sqlInsCar);
			if (!$stmt) {
				throw new Exception($link->error);
			}
			$sessionTemporal = $fecha_sys; // como en tu versión original
			$stmt->bind_param('ssssss', $fecha_sys, $idCliente, $idcli, $desc, $sessionTemporal, $tiendaProv);
			if (!$stmt->execute()) {
				throw new Exception($stmt->error);
			}
			$idCarrito = $link->insert_id;
			$stmt->close();

			// Genera cadena de sesión del carrito como en tu lógica original
			$f = str_replace([' ', '/', ':'], ['', '_', '_'], $fecha_sys);
			$_SESSION["_SESSIONCARRITO_"] = $idCarrito . $session . $f;
			$_SESSION["_IDCARRITOTV_"]    = $idCarrito;

			// Actualiza session del carrito con el valor definitivo
			$sqlUpdCar = "UPDATE carrito SET session = ? 
                          WHERE cve_carrito = ? AND cve_sysusuario = ?";
			$stmt = $link->prepare($sqlUpdCar);
			if (!$stmt) {
				throw new Exception($link->error);
			}
			$stmt->bind_param('sis', $_SESSION["_SESSIONCARRITO_"], $idCarrito, $idCliente);
			if (!$stmt->execute()) {
				throw new Exception($stmt->error);
			}
			$stmt->close();
		} else {
			$idCarrito = (int)($_SESSION["_IDCARRITOTV_"] ?? 0);
			if ($idCarrito <= 0) {
				// como reforzamiento, busca el carrito por session si no tienes el id en sesión
				$sqlFindCar = "SELECT cve_carrito FROM carrito WHERE session = ? AND cve_sysusuario = ? ORDER BY cve_carrito DESC LIMIT 1";
				$stmt = $link->prepare($sqlFindCar);
				if (!$stmt) {
					throw new Exception($link->error);
				}
				$stmt->bind_param('ss', $_SESSION["_SESSIONCARRITO_"], $idCliente);
				if (!$stmt->execute()) {
					throw new Exception($stmt->error);
				}
				$stmt->bind_result($idCarFound);
				if ($stmt->fetch()) {
					$idCarrito = (int)$idCarFound;
					$_SESSION["_IDCARRITOTV_"] = $idCarrito;
				}
				$stmt->close();
				if ($idCarrito <= 0) {
					throw new Exception('No se pudo identificar el carrito activo');
				}
			}
		}

		// 2) Obtiene datos del producto
		$sqlProd = "SELECT nombre, clave, pesomax
                    FROM producto
                    WHERE cve_statuscat = 1
                      AND cve_producto = ?
                      AND cve_sysusuario = ?
                    LIMIT 1";
		$stmt = $link->prepare($sqlProd);
		if (!$stmt) {
			throw new Exception($link->error);
		}
		$stmt->bind_param('is', $idprod, $idCliente);
		if (!$stmt->execute()) {
			throw new Exception($stmt->error);
		}
		$stmt->bind_result($p_nombre, $p_clave, $p_pesomax);
		if (!$stmt->fetch()) {
			$stmt->close();
			throw new Exception('Producto no encontrado');
		}
		$stmt->close();

		// 3) Obtiene precio
		$sqlPrecio = "SELECT precio
                      FROM productoprecio
                      WHERE cve_statuscat = 1
                        AND cve_producto = ?
                        AND cve_preciotipo = ?
                        AND cve_sysusuario = ?
                      LIMIT 1";
		$stmt = $link->prepare($sqlPrecio);
		if (!$stmt) {
			throw new Exception($link->error);
		}
		$stmt->bind_param('iis', $idprod, $tipoPrecio, $idCliente);
		if (!$stmt->execute()) {
			throw new Exception($stmt->error);
		}
		$stmt->bind_result($precio);
		if (!$stmt->fetch()) {
			$stmt->close();
			throw new Exception('Error al guardar... no hay precio asignado');
		}
		$stmt->close();

		// 4) Arma descripción (corrigiendo color)
		$txtAdd   = (strlen($addicional) >= 2) ? ('» Opcion: ' . $addicional) : '';
		$txtColor = (strlen($color)      >= 1) ? ('» Color: '  . $color)      : '';
		$descProd = trim($p_nombre . ' ' . $txtAdd . ' ' . $txtColor . ' » ' . $p_clave);

		// 5) Cálculos
		$precio   = (float)$precio;
		$subtotal = abs($precio) * abs($cant);
		$ivaCalc  = $subtotal * ($ivaCiudad / 100.0);
		$total    = $subtotal + $ivaCalc;

		// 6) ¿Existe ya el mismo producto en este carrito? Si sí, actualiza cantidad, si no, inserta
		$sqlFindDet = "SELECT cve_carritodet, cantidad
                       FROM carritodet
                       WHERE cve_statuscat = 1
                         AND cve_producto = ?
                         AND sessioncarrito = ?
                         AND cve_sysusuario = ?
                       ORDER BY cve_carritodet DESC
                       LIMIT 1";
		$stmt = $link->prepare($sqlFindDet);
		if (!$stmt) {
			throw new Exception($link->error);
		}
		$stmt->bind_param('iss', $idprod, $_SESSION["_SESSIONCARRITO_"], $idCliente);
		if (!$stmt->execute()) {
			throw new Exception($stmt->error);
		}
		$stmt->bind_result($idDetExist, $cantExist);
		$exists = $stmt->fetch();
		$stmt->close();

		if ($exists) {
			// Actualiza sumando cantidades
			$nuevaCant = (int)$cantExist + $cant;
			$nuevoSub  = abs($precio) * abs($nuevaCant);
			$nuevoIva  = $nuevoSub * ($ivaCiudad / 100.0);
			$nuevoTot  = $nuevoSub + $nuevoIva;

			$sqlUpdDet = "UPDATE carritodet SET
                            cantidad = ?,
                            precio   = ?,
                            subtotal = ?,
                            totiva   = ?,
                            total    = ?
                          WHERE cve_carritodet = ?
                            AND cve_statuscat = 1
                            AND cve_sysusuario = ?";
			$stmt = $link->prepare($sqlUpdDet);
			if (!$stmt) {
				throw new Exception($link->error);
			}
			$stmt->bind_param('iddddis', $nuevaCant, $precio, $nuevoSub, $nuevoIva, $nuevoTot, $idDetExist, $idCliente);
			if (!$stmt->execute()) {
				throw new Exception($stmt->error);
			}
			$stmt->close();
		} else {
			// Inserta el detalle
			$sqlInsDet = "INSERT INTO carritodet
                (cve_statuscat, fecha_sys, cve_sysusuario, cve_registro, cve_carrito,
                 cve_producto, session, sessioncarrito, descripcion, cantidad,
                 precio, subtotal, totiva, total, iva, pesomax, cve_tiendaprovedor, tinsert, color, talla)
                VALUES
                (1, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 0, 0, 0)";
			$stmt = $link->prepare($sqlInsDet);
			if (!$stmt) {
				throw new Exception($link->error);
			}
			$ivaPorc = $ivaCiudad; // campo "iva" almacena el % (como en tu lógica)
			$descProdSafe = str_replace("'", "", $descProd);

			$stmt->bind_param(
				'sssiisssidddddds',
				$fecha_sys,
				$idCliente,
				$idcli,
				$idCarrito,
				$idprod,
				$session,                      // session (temporal que envías desde el front)
				$_SESSION["_SESSIONCARRITO_"], // sessioncarrito (global del carrito)
				$descProdSafe,
				$cant,
				$precio,
				$subtotal,
				$ivaCalc,
				$total,
				$ivaPorc,
				$p_pesomax,
				$tiendaProv
			);
			if (!$stmt->execute()) {
				throw new Exception($stmt->error);
			}
			$iddet = $link->insert_id;
			$stmt->close();

			// Actualiza el campo "session" del detalle con su propio ID + session (como hacías)
			$sessionDet = $iddet . $session;
			$sqlUpdSess = "UPDATE carritodet SET session = ?
                           WHERE cve_carritodet = ?
                             AND cve_statuscat = 1
                             AND cve_sysusuario = ?";
			$stmt = $link->prepare($sqlUpdSess);
			if (!$stmt) {
				throw new Exception($link->error);
			}
			$stmt->bind_param('sis', $sessionDet, $iddet, $idCliente);
			if (!$stmt->execute()) {
				throw new Exception($stmt->error);
			}
			$stmt->close();
		}

		$link->commit();
		$msj = 'add';
	} catch (Exception $e) {
		$link->rollback();
		$msj = 'Error: ' . $e->getMessage();
	}

	return $msj;
}



// Variables de sesión y sistema
$idcli   = $_SESSION["_REG_ID"] ?? 0;
$session = session_id();
$fecha_sys = date("Y-m-d H:i:s");

// Recibir parámetros del JS
$idprod     = isset($_POST['uidproducto']) ? trim($_POST['uidproducto']) : null;
$cant       = isset($_POST['numprod']) ? intval($_POST['numprod']) : 1;
$addicional = isset($_POST['adicional']) ? trim($_POST['adicional']) : '';
$color      = isset($_POST['SColor']) ? trim($_POST['SColor']) : '';

// Validación básica
if (!$idprod) {
	echo "Error: producto inválido";
	exit;
}

$result = addcarrito($link, $fecha_sys, $idcli, $session, $idprod, $cant, $addicional, $color);


// Mensaje de salida
if ($result) {
	echo $_SESSION["_SESSIONCARRITO_"];
} else {
	echo "Error al agregar";
}
