<?php
session_start();
include("../include/BDQuery.php");
error_reporting(E_ALL);
ini_set('display_errors', 1);

header("Content-Type: application/json; charset=utf-8");

// Moneda desde sesión (fallback MXN)
$moneda = isset($_SESSION["_MONEDA_"]) ? (string)$_SESSION["_MONEDA_"] : "MXN";

// Validaciones de sesión requeridas
$sessionCarrito = isset($_SESSION["_SESSIONCARRITO_"]) ? (string)$_SESSION["_SESSIONCARRITO_"] : "";
$idCliente      = isset($_SESSION["_IDU_R"]) ? (string)$_SESSION["_IDU_R"] : "";

if ($sessionCarrito === "" || $idCliente === "") {
    echo json_encode([
        "ok"       => true,
        "count"    => 0,
        "total"    => 0.0,
        "currency" => $moneda,
        "status"   => "empty"
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// Consulta agregada (sin ORDER BY)
$sql = "
    SELECT
        COALESCE(SUM(a.cantidad), 0) AS cnt,
        COALESCE(SUM(a.total), 0)    AS tot
    FROM carritodet a
    WHERE a.cve_statuscat = 1
      AND a.sessioncarrito = ?
      AND a.cve_sysusuario = ?
    LIMIT 5
";

try {
    if (!($link instanceof mysqli)) {
        throw new Exception("Conexión inválida.");
    }

    if (!$stmt = $link->prepare($sql)) {
        throw new Exception($link->error);
    }

    $stmt->bind_param("ss", $sessionCarrito, $idCliente);

    if (!$stmt->execute()) {
        throw new Exception($stmt->error);
    }

    $stmt->bind_result($cnt, $tot);
    $stmt->fetch();
    $stmt->close();

    // Normaliza tipos para JSON
    $count = (int)$cnt;
    $total = (float)$tot;

    echo json_encode([
        "ok"       => true,
        "count"    => $count,
        "total"    => $total,
        "currency" => $moneda
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "ok"    => false,
        "error" => "addcarritotx: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}