<?php
function listado_inicial($link, $iduser)
{
  $iduser_safe = intval($iduser);

  $query = "SELECT p.cve_producto AS id_cachorro,
                   p.nombre AS nombre_cachorro,
                   p.clave AS rasgo_principal,
                   p.descripcion2 AS descripcion_corta,
                   pp.precio AS precio_cachorro,
                   p.imagen AS foto_principal,
                   p.url AS detalle_url,
                   p.cve_statuscat AS estatus_cachorro,
                   c.descripcion AS rasgo_secundario_raw,
                   s.descripcion AS sexo_raw
              FROM producto p
              INNER JOIN productoprecio pp ON p.cve_producto = pp.cve_producto
              LEFT JOIN categoria c ON p.cve_categoria = c.cve_categoria
              LEFT JOIN categoriasub s ON p.cve_categoriasub = s.cve_categoriasub

              WHERE p.cve_sysusuario = ?
              AND p.cve_statuscat IN (1, 2)
              AND pp.cve_statuscat = 1
              AND p.cve_categoria = 3331
              ORDER BY p.cve_producto DESC
              LIMIT 6";

  $types = "i";
  $params = [$iduser_safe];

  $stmt = mysqli_prepare($link, $query);
  if (!$stmt) {
    error_log("Error al preparar la consulta de cachorros: " . mysqli_error($link));
    return '';
  }

  mysqli_stmt_bind_param($stmt, $types, ...$params);
  mysqli_stmt_execute($stmt);
  $result = mysqli_stmt_get_result($stmt);

  if (mysqli_num_rows($result) == 0) {
    return '<div class="col-12"><p class="alert alert-info text-center">No hay cachorros disponibles para mostrar.</p></div>';
  }

  $products_html = '';
  while ($row = mysqli_fetch_assoc($result)) {

    $estatus_id = (int) $row["estatus_cachorro"];
    $badge_class = 'bg-secondary';
    $badge_texto = 'No Disponible';

    if ($estatus_id === 1) {
      $badge_class = 'bg-success';
      $badge_texto = 'Disponible';
    } elseif ($estatus_id === 2) {
      $badge_class = 'bg-warning';
      $badge_texto = 'Apartado';
    }

    $sexo_raw = strtoupper(trim($row["sexo_raw"] ?? ''));
    $sexo = 'Indefinido';

    if (strpos($sexo_raw, 'HEMBRA') !== false || strpos($sexo_raw, 'F') !== false) {
      $sexo = 'Hembra';
    } elseif (strpos(strtoupper($sexo_raw), 'MACHO') !== false || strpos($sexo_raw, 'M') !== false) {
      $sexo = 'Macho';
    }

    $nombre = htmlspecialchars($row["nombre_cachorro"]);
    $rasgo_clave = htmlspecialchars($row["rasgo_principal"] ?? 'Sin clave');
    $rasgo_secundario = htmlspecialchars($row["rasgo_secundario_raw"] ?? 'Rasgo único');
    $descripcion_corta = htmlspecialchars($row["descripcion_corta"] ?? 'Cachorro hermoso y sano.');

    $precio = htmlspecialchars(number_format($row["precio_cachorro"], 2));
    $imagen_url = 'https://www.negocio.me/img-tienda-virtual/' . htmlspecialchars($row["foto_principal"]);
    $detalle_url = $_SESSION["url_ruta"] . '/detalle/' . htmlspecialchars($row["detalle_url"] . '/' . $row["id_cachorro"]);

    $products_html .= '
            <div class="col-md-6 col-lg-4">
                <div class="card h-100 shadow-sm">
                    <a href="' . $detalle_url . '" class="text-decoration-none">
                        <img src="' . $imagen_url . '"
                             class="card-img-top"
                             alt="Cachorro ' . $nombre . '"
                             style="height: 250px; object-fit: cover;">
                    </a>
                    <div class="card-body">
                        <span class="badge ' . $badge_class . ' mb-2">' . $badge_texto . '</span>
                        <h5 class="card-title">' . $nombre . ' - ' . $sexo . '</h5>
                        <p class="card-text">
                            <small class="text-muted">' . $rasgo_clave . '  </small><br>
                            ' . $descripcion_corta . '
                        </p>
                        <div class="d-grid gap-2">
                            <a href="' . $detalle_url . '" class="btn btn-primary">Ver detalles</a>
                            <a href="https://wa.me/525661077466?text=Hola!%20Estoy%20interesado%20en%20el%20cachorro%20' . $nombre . '" class="btn btn-outline-success">
                                <i class="bi bi-whatsapp"></i> Preguntar por WhatsApp
                            </a>
                        </div>
                    </div>
                </div>
            </div>';
  }

  mysqli_stmt_close($stmt);

  return $products_html;
}

// function listado_inicial2($link, $iduser)
// {
//   $iduser_safe = intval($iduser);
//   $query = "SELECT p.cve_producto AS id_cachorro,
//                    p.nombre AS nombre_cachorro,
//                    p.clave AS rasgo_principal,
//                    p.descripcion2 AS descripcion_corta,
//                    pp.precio AS precio_cachorro,
//                    p.imagen AS foto_principal,
//                    p.url AS detalle_url,
//                    p.cve_statuscat AS estatus_cachorro,
//                    c.descripcion AS rasgo_secundario_raw,
//                    s.descripcion AS sexo_raw
//               FROM producto p
//               INNER JOIN productoprecio pp ON p.cve_producto = pp.cve_producto
//               LEFT JOIN categoria c ON p.cve_categoria = c.cve_categoria
//               LEFT JOIN categoriasub s ON p.cve_categoriasub = s.cve_categoriasub

//               WHERE p.cve_sysusuario = ?
//               AND p.cve_statuscat IN (1, 2)
//               AND pp.cve_statuscat = 1
//               AND p.cve_categoria = 3329
//               ORDER BY p.cve_producto DESC
//               LIMIT 10";

//   $types = "i";
//   $params = [$iduser_safe];

//   $stmt = mysqli_prepare($link, $query);
//   if (!$stmt) {
//     error_log("Error al preparar la consulta de cachorros: " . mysqli_error($link));
//     return '';
//   }

//   mysqli_stmt_bind_param($stmt, $types, ...$params);
//   mysqli_stmt_execute($stmt);
//   $result = mysqli_stmt_get_result($stmt);

//   if (mysqli_num_rows($result) == 0) {
//     return '<div class="col-12"><p class="alert alert-info text-center">No hay cachorros disponibles para mostrar.</p></div>';
//   }

//   $products_html = '';
//   while ($row = mysqli_fetch_assoc($result)) {

//     $estatus_id = (int) $row["estatus_cachorro"];
//     $badge_class = 'bg-secondary';
//     $badge_texto = 'No Disponible';

//     if ($estatus_id === 1) {
//       $badge_class = 'bg-success';
//       $badge_texto = 'Disponible';
//     } elseif ($estatus_id === 2) {
//       $badge_class = 'bg-warning';
//       $badge_texto = 'Apartado';
//     }

//     $sexo_raw = strtoupper(trim($row["sexo_raw"] ?? ''));
//     $sexo = 'Indefinido';

//     if (strpos($sexo_raw, 'HEMBRA') !== false || strpos($sexo_raw, 'F') !== false) {
//       $sexo = 'Hembra';
//     } elseif (strpos(strtoupper($sexo_raw), 'MACHO') !== false || strpos($sexo_raw, 'M') !== false) {
//       $sexo = 'Macho';
//     }

//     $nombre = htmlspecialchars($row["nombre_cachorro"]);
//     $rasgo_clave = htmlspecialchars($row["rasgo_principal"] ?? 'Sin clave');
//     $rasgo_secundario = htmlspecialchars($row["rasgo_secundario_raw"] ?? 'Rasgo único');
//     $descripcion_corta = htmlspecialchars($row["descripcion_corta"] ?? 'Cachorro hermoso y sano.');

//     $precio = htmlspecialchars(number_format($row["precio_cachorro"], 2));
//     $imagen_url = 'https://www.negocio.me/img-tienda-virtual/' . htmlspecialchars($row["foto_principal"]);
//     $detalle_url = '/shibainumet/detalle/' . htmlspecialchars($row["detalle_url"] ?? $row["id_cachorro"]);

//     $products_html .= '
//             <div class="swiper-slide">
//                 <div class="card h-100 shadow-sm">
//                     <a href="' . $detalle_url . '" class="text-decoration-none">
//                         <img src="' . $imagen_url . '"
//                              class="card-img-top"
//                              alt="Cachorro ' . $nombre . '"
//                              style="height: 250px; object-fit: cover;">
//                     </a>
//                     <div class="card-body">
//                         <span class="badge ' . $badge_class . ' mb-2">' . $badge_texto . '</span>
//                         <h5 class="card-title">' . $nombre . '</h5>
//                         <p class="card-text">
//                             <small class="text-muted">' . $rasgo_clave . '  </small><br>
//                             ' . $descripcion_corta . '
//                         </p>
//                         <div class="d-grid gap-2">
//                             <a href="' . $detalle_url . '" class="btn btn-primary">Ver detalles</a>
//                             <a href="https://wa.me/TU_NUMERO_WHATSAPP?text=Hola!%20Estoy%20interesado%20en%20el%20cachorro%20' . $nombre . '" class="btn btn-outline-success">
//                                 <i class="bi bi-whatsapp"></i> Preguntar por WhatsApp
//                             </a>
//                         </div>
//                     </div>
//                 </div>
//             </div>';
//   }

//   mysqli_stmt_close($stmt);

//   $output = '
//         <div class="swiper mySwiper">
//             <div class="swiper-wrapper">
//                 ' . $products_html . '
//             </div>
//             <div class="swiper-pagination"></div>
//             <div class="swiper-button-next"></div>
//             <div class="swiper-button-prev"></div>
//         </div>';

//   return $output;
// }

function mostrar_imagen_unica($link, $cve_slider, $disp)
{
  $disp = in_array($disp, ['movil', 'pc']) ? $disp : 'pc';
  $cve_slider_safe = intval($cve_slider);

  if (!isset($_SESSION["_IDU_R"])) {
    return '';
  }
  $idu_r_safe = intval($_SESSION["_IDU_R"]);

  $movil_filter = ($disp === 'movil') ? 1 : 0;

  $query = "
        SELECT a.imagen, a.descripcion FROM
        tiendasliddet a
        INNER JOIN tiendaslid b on a.cve_tiendaslid = b.cve_tiendaslid
        WHERE
            a.cve_sysusuario = " . $idu_r_safe . "
            AND a.cve_statuscat = 1
            AND b.cve_statuscat = 1
            AND a.cve_tiendaslid = " . $cve_slider_safe . "
            AND a.movil = " . $movil_filter . "
        ORDER BY a.orden ASC
        LIMIT 1";

  $datos = @mysqli_query($link, $query);

  if (!$datos || @mysqli_num_rows($datos) == 0) {
    return '';
  }

  $row = @mysqli_fetch_assoc($datos);

  $imagen_url = 'https://www.negocio.me/imagen/' . htmlspecialchars($row["imagen"]);
  $alt_text = htmlspecialchars($row["descripcion"]);

  $retorno = '<div class="hero-image-container position-relative overflow-hidden" style="height: 100%;">
                <img src="' . $imagen_url . '" alt="' . $alt_text . '" class="position-absolute top-0 start-0 w-100 h-100 object-fit-cover">
              </div>
              ';
  return $retorno;
}

function generar_resumen_blog($link, $cve_blog)
{
  $cve_blog_safe = intval($cve_blog);

  $query = "
    SELECT a.cve_blogdet, a.titulo, a.descripcion, a.imagen, a.url FROM blogdet a  
    WHERE a.cve_blog = $cve_blog_safe
    AND a.cve_statuscat = 1 
    ORDER BY a.cve_blogdet DESC;
  ";
  $qryTR = @mysqli_query($link, $query);

  $resumen_html = "";

  if (!$qryTR || @mysqli_num_rows($qryTR) == 0) {
    return '<div class="col-12"><p class="alert alert-info text-center">No hay entradas de blog disponibles.</p></div>';
  }

  while ($rowtr = @mysqli_fetch_array($qryTR)) {
    $titulo = htmlspecialchars($rowtr["titulo"]);
    $descripcion = htmlspecialchars(substr($rowtr["descripcion"], 0, 150)) . '...';
    $imagen_url = 'https://www.negocio.me/img-blog/' . htmlspecialchars($rowtr["imagen"]);

    $detalle_url = $_SESSION["url_ruta"] . '/blog/' . htmlspecialchars($rowtr["url"]) . '/' . htmlspecialchars($rowtr["cve_blogdet"]);

    $resumen_html .= '
      <div class="col-lg-12 mb-4">
        <div class="card shadow-sm">
          <div class="row g-0">
            <div class="col-md-4">
              <a href="' . $detalle_url . '">
                <img src="' . $imagen_url . '" class="img-fluid rounded-start w-100 h-100" 
                     style="object-fit: cover;" alt="' . $titulo . '">
              </a>
            </div>
            <div class="col-md-8">
              <div class="card-body">
                <h3 class="card-title h5">' . $titulo . '</h3>
                <p class="card-text small text-muted">' . $descripcion . '</p>
                <a href="' . $detalle_url . '" class="btn btn-sm btn-danger mt-2">Leer tema completo</a>
              </div>
            </div>
          </div>
        </div>
      </div>
    ';
  }

  return $resumen_html;
}

function generar_sidebar_temas_recientes($link, $cve_blog)
{
  $cve_blog_safe = intval($cve_blog);
  $query = "
    SELECT a.titulo, a.url, a.cve_blogdet FROM blogdet a  
    WHERE a.cve_blog = $cve_blog_safe
    AND a.cve_statuscat = 1 
    ORDER BY a.cve_blogdet DESC
    LIMIT 10;
  ";
  $qryTR = @mysqli_query($link, $query);

  $sidebar_html = "";

  if (!$qryTR || @mysqli_num_rows($qryTR) == 0) {
    return '<li><span class="text-muted small">No hay temas recientes.</span></li>';
  }

  while ($rowtr = @mysqli_fetch_array($qryTR)) {
    $detalle_url = '/blog/' . htmlspecialchars($rowtr["url"]) . '/' . htmlspecialchars($rowtr["cve_blogdet"]);
    $sidebar_html .= '
      <li class="mb-2">
        <a href="' . $detalle_url . '" class="text-decoration-none text-dark small fw-normal">
          ' . substr(htmlspecialchars($rowtr["titulo"]), 0, 80) . '...
        </a>
      </li>
    ';
  }

  return '
    <div class="p-4 bg-light rounded shadow-sm">
      <h4 class="fw-bold mb-3 border-bottom pb-2">Temas Recientes</h4>
      <ul class="list-unstyled">
        ' . $sidebar_html . '
      </ul>
    </div>';
}

function blog_seccion_completa_detalle($link, $cve_blog, $cve_blogdet)
{
  $cve_blog_safe = intval($cve_blog);
  $cve_blogdet_safe = intval($cve_blogdet);

  $query = "
    SELECT a.* FROM blogdet a  
    WHERE a.cve_blog = $cve_blog_safe
    AND a.cve_blogdet = $cve_blogdet_safe 
    AND a.cve_statuscat = 1 
    LIMIT 1;
  ";
  $qryTR = @mysqli_query($link, $query);

  if (!$qryTR || @mysqli_num_rows($qryTR) == 0) {
    return '<div class="col-12"><p class="alert alert-warning text-center">La entrada de blog solicitada no existe o no está disponible.</p></div>';
  }

  $rowtr = @mysqli_fetch_array($qryTR);

  $imagen_url = 'https://www.negocio.me/img-blog/' . htmlspecialchars($rowtr["imagen"]);
  $titulo_principal = htmlspecialchars($rowtr["titulo"]);
  $descripcion_corta = htmlspecialchars($rowtr["descripcion"]);
  $contenido_completo = $rowtr["contenido"];

  $detalle_html = '
    <div class="blog-detail">
      <h1 class="display-5 fw-bold mb-3">' . $titulo_principal . '</h1>
      <p class="lead text-muted">' . $descripcion_corta . '</p>

      <div class="my-4">
        <img class="img-fluid rounded w-100" src="' . $imagen_url . '" alt="' . htmlspecialchars($rowtr["imagen_alt"] ?? $titulo_principal) . '">
      </div>

      <div class="blog-content">
        ' . $contenido_completo . '
      </div>
    </div>
  ';

  $temas_recientes_sidebar = generar_sidebar_temas_recientes($link, $cve_blog);

  return '
    <div class="row">
      <div class="col-lg-8">
        ' . $detalle_html . '
      </div>
      <div class="col-lg-4 mt-5 mt-lg-0">
        ' . $temas_recientes_sidebar . '
      </div>
    </div>
  ';
}

function producto_galeria($link, $id_producto)
{
  $id_producto_safe = intval($id_producto);
  $imagenes = [];

  $query_img = "SELECT imagen FROM productoimg WHERE cve_producto = ? AND cve_statuscat = 1 ORDER BY cve_productoimg ASC LIMIT 10";
  $stmt_img = mysqli_prepare($link, $query_img);
  mysqli_stmt_bind_param($stmt_img, "i", $id_producto_safe);
  mysqli_stmt_execute($stmt_img);
  $result_img = mysqli_stmt_get_result($stmt_img);

  while ($row = mysqli_fetch_assoc($result_img)) {
    $imagenes[] = $row['imagen'];
  }
  mysqli_stmt_close($stmt_img);

  if (empty($imagenes)) {
    $query_main = "SELECT imagen FROM producto WHERE cve_producto = ? AND cve_statuscat = 1";
    $stmt_main = mysqli_prepare($link, $query_main);
    mysqli_stmt_bind_param($stmt_main, "i", $id_producto_safe);
    mysqli_stmt_execute($stmt_main);
    $result_main = mysqli_stmt_get_result($stmt_main);
    if ($row_main = mysqli_fetch_assoc($result_main)) {
      $imagenes[] = $row_main['imagen'];
    }
    mysqli_stmt_close($stmt_main);
  }

  if (empty($imagenes)) {
    return '<p class="alert alert-warning">No hay imágenes para este producto.</p>';
  }

  $slider_principal = '';
  $slider_thumbs = '';

  foreach ($imagenes as $img) {
    $url_grande = 'https://www.negocio.me/img-tienda-virtual/' . htmlspecialchars($img);
    $url_thumb = 'https://www.negocio.me/img-tienda-virtual/th/' . htmlspecialchars($img);

    $slider_principal .= '
            <div class="swiper-slide">
                <img src="' . $url_grande . '" alt="Imagen de producto" class="img-fluid rounded">
            </div>';

    $slider_thumbs .= '
            <div class="swiper-slide">
                <img src="' . $url_thumb . '" alt="Miniatura de producto" class="img-fluid rounded">
            </div>';
  }

  $galeria_html = '
        <div>
            <div class="swiper product-gallery-main">
                <div class="swiper-wrapper">' . $slider_principal . '</div>
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>
            <div thumbsSlider="" class="swiper product-gallery-thumbs mt-3">
                <div class="swiper-wrapper">' . $slider_thumbs . '</div>
            </div>
        </div>';

  return $galeria_html;
}

function producto_detalles($link, $id_producto)
{
  $id_producto_safe = intval($id_producto);
  $opciones_html = '';

  $query_opciones = "SELECT descripcion FROM productoaddi WHERE cve_producto = ? AND cve_statuscat = 1";
  $stmt_opciones = mysqli_prepare($link, $query_opciones);
  mysqli_stmt_bind_param($stmt_opciones, "i", $id_producto_safe);
  mysqli_stmt_execute($stmt_opciones);
  $result_opciones = mysqli_stmt_get_result($stmt_opciones);

  while ($row = mysqli_fetch_assoc($result_opciones)) {
    $opcion = htmlspecialchars($row['descripcion']);
    $opciones_html .= '
            <div>
                <input type="radio" class="btn-check" name="opcion_producto" id="opcion_' . $opcion . '" value="' . $opcion . '" autocomplete="off">
                <label class="btn btn-outline-secondary" for="opcion_' . $opcion . '">' . $opcion . '</label>
            </div>';
  }
  mysqli_stmt_close($stmt_opciones);

  $query_prod = "SELECT
                      p.nombre,
                      p.descripcion2,
                      pp.precio,
                      pd.contenido
                  FROM producto p
                  INNER JOIN productoprecio pp ON p.cve_producto = pp.cve_producto
                  LEFT JOIN productodet pd ON p.cve_producto = pd.cve_producto AND pd.cve_statuscat = 1
                  WHERE
                      p.cve_producto = ?
                      AND p.cve_statuscat = 1
                      AND pp.cve_statuscat = 1
                      AND pp.cve_preciotipo = 1
                  LIMIT 1";

  $stmt_prod = mysqli_prepare($link, $query_prod);
  mysqli_stmt_bind_param($stmt_prod, "i", $id_producto_safe);
  mysqli_stmt_execute($stmt_prod);
  $result_prod = mysqli_stmt_get_result($stmt_prod);

  if (!($producto = mysqli_fetch_assoc($result_prod))) {
    return '<p class="alert alert-danger">Producto no encontrado.</p>';
  }
  mysqli_stmt_close($stmt_prod);

  $nombre = htmlspecialchars($producto['nombre']);
  $descripcion = htmlspecialchars($producto['descripcion2']);
  $contenido = htmlspecialchars($producto['contenido']);
  $precio = htmlspecialchars(number_format($producto['precio'], 2));

  $seccion_opciones = '';
  if (!empty($opciones_html)) {
    $seccion_opciones = '
            <div class="mb-4">
                <h6 class="fw-bold">Selecciona una opción:</h6>
                <div class="d-flex flex-wrap gap-2">' . $opciones_html . '</div>
            </div>';
  }

  $detalles_html = '
        <h2 class="fw-bold mb-2">' . $nombre . '</h2>
        <p class="h3 text-success mb-4">$' . $precio . ' <small class="text-muted">MXN</small></p>
        <p class="text-muted">' . $descripcion . '</p>
        ' . $seccion_opciones . '
        <div class="d-grid">
            <a href="https://wa.me/525661077466?text=Hola!%20Estoy%20interesado%20en%20el%20cachorro%20' . $nombre . '" class="btn btn-lg btn-success w-100 ">
                <i class="bi bi-whatsapp"></i> Preguntar por WhatsApp
            </a>
        </div>
        <hr class="my-4">
        <div>
            <div class="accordion" id="accordionInfo">
              <div class="accordion-item">
                <h2 class="accordion-header" id="headingOne">
                  <button class="accordion-button " aria-expanded="true" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne">
                    Información del producto
                  </button>
                </h2>
                <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionInfo" aria-expanded="true">
                  <div class="accordion-body">
                    ' . $contenido . '
                  </div>
                </div>
              </div>

            </div>
        </div>';

  return $detalles_html;
}

function productos($link, $iduser, $var = 0, $var2 = 0)
{
  $iduser_safe = intval($iduser);
  $categoria_safe = intval($var);
  $subcategoria_safe = intval($var2);
  $query = "SELECT p.cve_producto, p.nombre, p.imagen, pp.precio, 
                   p.clave AS rasgo_principal, 
                   p.descripcion2 AS descripcion_corta,
                   p.url AS url_amigable,
                   p.cve_statuscat,
                   s.descripcion AS sub_descripcion
              FROM producto p
              INNER JOIN productoprecio pp ON p.cve_producto = pp.cve_producto
              LEFT JOIN categoriasub s ON p.cve_categoriasub = s.cve_categoriasub
              WHERE p.cve_sysusuario = ?
              AND p.cve_statuscat IN (1, 2) 
              AND pp.cve_statuscat = 1";

  $types = "i";
  $params = [$iduser_safe];
  $query .= ($categoria_safe > 0) ? " AND p.cve_categoria = ?" : "";
  $query .= ($subcategoria_safe > 0) ? " AND p.cve_categoriasub = ?" : "";

  $query .= " ORDER BY p.cve_producto DESC";

  if ($categoria_safe > 0) {
    $types .= "i";
    $params[] = $categoria_safe;
  }

  if ($subcategoria_safe > 0) {
    $types .= "i";
    $params[] = $subcategoria_safe;
  }

  $stmt = mysqli_prepare($link, $query);
  if (!$stmt) return '';
  mysqli_stmt_bind_param($stmt, $types, ...$params);
  mysqli_stmt_execute($stmt);
  $result = mysqli_stmt_get_result($stmt);

  if (mysqli_num_rows($result) == 0) {
    return '<div class="col-12"><p class="alert alert-info text-center">No se encontraron productos en esta sección.</p></div>';
  }

  $products_html = '';
  while ($row = mysqli_fetch_assoc($result)) {
    $estatus_id = (int) $row["cve_statuscat"];
    $badge_class = 'bg-secondary';
    $badge_texto = 'No Disponible';

    if ($estatus_id === 1) {
      $badge_class = 'bg-success';
      $badge_texto = 'Disponible';
    } elseif ($estatus_id === 2) {
      $badge_class = 'bg-warning';
      $badge_texto = 'Apartado';
    }
    $sexo_raw = strtoupper(trim($row["sub_descripcion"] ?? ''));
    $sexo = '';
    if (strpos($sexo_raw, 'HEMBRA') !== false || strpos($sexo_raw, 'F') !== false) {
      $sexo = ' - Hembra';
    } elseif (strpos(strtoupper($sexo_raw), 'MACHO') !== false || strpos($sexo_raw, 'M') !== false) {
      $sexo = ' - Macho';
    }

    $nombre = htmlspecialchars($row["nombre"]);
    $rasgo_clave = htmlspecialchars($row["rasgo_principal"] ?? '');
    $descripcion_corta = htmlspecialchars($row["descripcion_corta"] ?? '');
    $precio = htmlspecialchars(number_format($row["precio"], 2));
    $imagen_url = 'https://www.negocio.me/img-tienda-virtual/' . htmlspecialchars($row["imagen"]);
    $slug = !empty($row["url_amigable"]) ? $row["url_amigable"] : $row["cve_producto"];
    $detalle_url = $_SESSION["url_ruta"] . '/detalle/' . htmlspecialchars($slug);

    $products_html .= '
            <div class="col-md-6 col-lg-4 mb-4">
                <div class="card h-100 shadow-sm">
                    <a href="' . $detalle_url . '" class="text-decoration-none">
                        <img src="' . $imagen_url . '"
                             class="card-img-top"
                             alt="' . $nombre . '"
                             style="height: 250px; object-fit: cover;">
                    </a>
                    <div class="card-body">
                        <span class="badge ' . $badge_class . ' mb-2">' . $badge_texto . '</span>
                        <h5 class="card-title text-dark">' . $nombre . $sexo . '</h5>
                        <p class="card-text text-muted">
                            <small class="fw-bold">' . $rasgo_clave . '</small><br>
                            ' . $descripcion_corta . '
                        </p>

                        <div class="d-grid gap-2 mt-auto">
                            <a href="' . $detalle_url . '" class="btn btn-primary">Ver detalles</a>
                            <a href="https://wa.me/525661077466?text=Hola!%20Estoy%20interesado%20en%20' . $nombre . '" class="btn btn-outline-success" target="_blank">
                                <i class="bi bi-whatsapp"></i> Preguntar por WhatsApp
                            </a>
                        </div>
                    </div>
                </div>
            </div>';
  }

  mysqli_stmt_close($stmt);
  return $products_html;
}

function menu_categorias($link, $iduser)
{
  $iduser_safe = intval($iduser);
  $query = "SELECT c.cve_categoria, c.descripcion AS cat_nombre, 
                   s.cve_categoriasub, s.descripcion AS sub_nombre,
                   c.url AS cat_url
              FROM categoria c
              LEFT JOIN categoriasub s ON c.cve_categoria = s.cve_categoria AND s.cve_statuscat = 1
              WHERE c.cve_sysusuario = ? AND c.cve_statuscat = 1
              ORDER BY c.descripcion ASC, s.descripcion ASC";

  $stmt = mysqli_prepare($link, $query);
  mysqli_stmt_bind_param($stmt, "i", $iduser_safe);
  mysqli_stmt_execute($stmt);
  $result = mysqli_stmt_get_result($stmt);

  $data = [];
  while ($row = mysqli_fetch_assoc($result)) {
    $cat_id = $row['cve_categoria'];
    if (!isset($data[$cat_id])) {
      $data[$cat_id] = [
        'nombre' => $row['cat_nombre'],
        'subs' => [],
        'cat_url' => $row['cat_url']
      ];
    }
    if ($row['cve_categoriasub']) {
      $data[$cat_id]['subs'][] = [
        'id' => $row['cve_categoriasub'],
        'nombre' => $row['sub_nombre'],
        'cat_url' => $row['cat_url']
      ];
    }
  }
  mysqli_stmt_close($stmt);
  $html = '<div class="list-group shadow-sm">';
  $html .= '<a href="' . $_SESSION["url_ruta"] . '/tienda" class="list-group-item list-group-item-action fw-bold">
                <i class="bi bi-grid-fill me-2"></i> Ver Todos los Productos
              </a>';

  foreach ($data as $cat_id => $categoria) {
    $url_cat = $_SESSION["url_ruta"] . "/tienda/" . $categoria['cat_url'] . "/" . $cat_id;

    $html .= '<div class="list-group-item">';
    $html .= '<a href="' . $url_cat . '" class="text-decoration-none text-dark fw-bold d-block">' . htmlspecialchars($categoria['nombre']) . '</a>';

    if (!empty($categoria['subs'])) {
      $html .= '<ul class="list-unstyled ms-3 mt-2 mb-0 border-start ps-2">';
      foreach ($categoria['subs'] as $sub) {
        $url_sub = $_SESSION["url_ruta"] . "/tienda/" . $sub['cat_url'] . "/" . $cat_id . "/" . $sub['id'];
        $html .= '<li>
                    <a href="' . $url_sub . '" class="text-decoration-none text-muted small d-block py-1">
                        ' . htmlspecialchars($sub['nombre']) . '
                    </a>
                  </li>';
      }
      $html .= '</ul>';
    }
    $html .= '</div>';
  }
  $html .= '</div>';

  return $html;
}
