<?
include("_integra/include/conn.php");
include("_integra/include/funciones-nuevas.php")
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <? include("_integra/include/head.php"); ?>
</head>

<body>

    <? include("_integra/include/header.php"); ?>

    <!-- Hero Section -->
    <section class="position-relative min-vh-100 d-flex align-items-center bg-light" id="contacto">

        <div class="position-absolute top-0 start-0 w-100 h-100 d-none d-sm-block">
            <?php echo mostrar_imagen_unica($link, 897, 'pc'); ?>
        </div>

        <div class="position-absolute top-0 start-0 w-100 h-100 d-block d-sm-none">
            <?php echo mostrar_imagen_unica($link, 897, 'movil'); ?>
        </div>
        <div class="position-absolute top-0 start-0 w-100 h-100 bg-dark opacity-50"></div>

        <div class="container position-relative">
            <div class="row">
                <div class="col-lg-8">
                    <h1 class="display-3 fw-bold text-white mb-4">
                        25 Años Criando Shiba Inu con Amor, Ética y Profesionalismo
                    </h1>
                    <p class="lead text-white mb-5">
                        Conectamos familias con Shibas Inu criados con responsabilidad, cuidado integral y transparencia total.
                    </p>
                    <div class="d-flex flex-wrap gap-3 mb-5">
                        <a href="#cachorros" class="btn btn-primary btn-lg px-4 py-3 rounded-pill">
                            Ver cachorros disponibles
                        </a>
                        <a href="#contacto" class="btn btn-outline-light btn-lg px-4 py-3 rounded-pill">
                            Agendar videollamada
                        </a>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card shadow-lg">
                        <div class="card-body p-4">
                            <h3 class="card-title h5 mb-3">Agenda una videollamada</h3>
                            <p class="small text-muted mb-4">Conoce a tu futuro Shiba Inu en tiempo real</p>
                            <form id="_jx_mn_form" name="_jx_mn_form" method="post">
                                <input type="hidden" name="x_d_fom" id="x_d_fom" value="FormSaveJS">
                                <input type="hidden" name="idksys" id="idksys" value="1666_Reconf_1666">
                                <input type="hidden" name="x_d_titulo" id="x_d_titulo" value="Shibainumet - Contacto Hero">
                                <textarea name="idx_pers" id="idx_pers" style="font-size:12px;display:none;">
                               Ciudad: #fn_1#
                            </textarea>

                                <div class="mb-3">
                                    <input type="text" class="form-control" name="bs_nombre" placeholder="Nombre completo" required>
                                </div>
                                <div class="mb-3">
                                    <input type="tel" class="form-control" name="bs_telefono" placeholder="WhatsApp" required>
                                </div>
                                <div class="mb-3">
                                    <input type="email" class="form-control" name="bs_email" placeholder="Email" required>
                                </div>
                                <div class="mb-3">
                                    <select class="form-select" name="fn_1">
                                        <option>Ciudad</option>
                                        <option>CDMX</option>
                                        <option>Guadalajara</option>
                                        <option>Monterrey</option>
                                        <option>Querétaro</option>
                                        <option>Otra</option>
                                    </select>
                                </div>
                                <button type="submit" id="BtnEnviar" name="BtnEnviar" class="btn btn-primary w-100">Enviar solicitud</button>
                                <div class="text-center mt-2">
                                    <span id="LoadForm" class="LoadForm" name="LoadForm"></span>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
    </section>

    <!-- Presentación -->
    <!-- <section class="py-5">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <img src="https://images.unsplash.com/photo-1567225591450-06036b3392a6?w=600&h=400&fit=crop"
                        alt="Shiba Inu adulto"
                        class="img-fluid rounded shadow">
                </div>
                <div class="col-lg-6">
                    <h2 class="display-5 fw-bold mb-4">Shibainu Met: Guardianes del Legado del Shiba Inu en México</h2>
                    <p class="lead mb-4">
                        En Shibainu Met llevamos 25 años dedicados exclusivamente al Shiba Inu. No somos un criador improvisado;
                        somos una institución con experiencia nacional e internacional, comprometida con la crianza ética,
                        el bienestar animal y la correcta integración de cada Shiba Inu a su nuevo hogar.
                    </p>
                    <div class="row g-3 mb-4">
                        <div class="col-md-6">
                            <div class="d-flex">
                                <i class="bi bi-check-circle-fill text-primary me-3"></i>
                                <span>25 años de experiencia verificable</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex">
                                <i class="bi bi-check-circle-fill text-primary me-3"></i>
                                <span>Dedicación 100% exclusiva al Shiba Inu</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex">
                                <i class="bi bi-check-circle-fill text-primary me-3"></i>
                                <span>Transparencia total en todo el proceso</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex">
                                <i class="bi bi-check-circle-fill text-primary me-3"></i>
                                <span>Selección personalizada según tu estilo de vida</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex">
                                <i class="bi bi-check-circle-fill text-primary me-3"></i>
                                <span>Cuidado 360° desde nacimiento hasta la entrega</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex">
                                <i class="bi bi-check-circle-fill text-primary me-3"></i>
                                <span>Acompañamiento profesional paso a paso</span>
                            </div>
                        </div>
                    </div>
                    <a href="#historia" class="btn btn-outline-primary">Conoce más sobre nuestra historia</a>
                </div>
            </div>
        </div>
    </section> -->

    <section class="py-5 bg-light" id="proposito">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <img src="https://images.unsplash.com/photo-1567225591450-06036b3392a6?w=600&h=400&fit=crop"
                        alt="Shiba Inu adulto y criador"
                        class="img-fluid rounded shadow">
                </div>
                <div class="col-lg-6">
                    <h2 class="display-5 fw-bold mb-4">25 Años Creando Legados: Encuentra el Alma de Japón que Espera por Ti.</h2>
                    <p class="lead mb-4">
                        "En Shibainu Met, facilitamos la conexión responsable con la inteligencia y lealtad del Shiba Inu. Con más de 25 años de experiencia entregando a nivel nacional e internacional, somos una institución con un cuarto de siglo de historia, no un criador improvisado."
                    </p>
                    <div class="row g-3 mb-4">
                        <div class="col-md-6">
                            <div class="d-flex">
                                <i class="bi bi-check-circle-fill text-primary me-3"></i>
                                <span>Dedicación 100% exclusiva al Shiba Inu</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex">
                                <i class="bi bi-check-circle-fill text-primary me-3"></i>
                                <span>25 años de experiencia verificable</span>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="d-flex">
                                <i class="bi bi-check-circle-fill text-primary me-3"></i>
                                <span>Solución integral: del nacimiento a la entrega segura (soporte 360°)</span>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="d-flex">
                                <i class="bi bi-check-circle-fill text-primary me-3"></i>
                                <span>Propósito: Crear vínculos reales y un compromiso de por vida</span>
                            </div>
                        </div>
                    </div>
                    <p class="mt-4 fst-italic">
                        Misión: Impulsar el bienestar animal y la conexión humana amorosa.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5" id="legado">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10 text-center">
                    <h2 class="display-6 fw-bold mb-4">¿Por qué poseer un Shiba Inu? El Alma de un Tesoro Nacional de Japón</h2>
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <p class="lead text-center mb-4">
                        Su nombre, que se traduce como "perro pequeño", esconde un espíritu gigante. Declarado Tesoro Nacional de Japón, el Shiba Inu es más que un perro; es un legado viviente.
                    </p>
                    <div class="bg-white p-4 rounded shadow-sm">
                        <p class="mb-3">
                            Su andar es una muestra de dignidad, su mirada denota una inteligencia profunda y su carácter independiente es un reflejo de su herencia autosuficiente. No es un perro que busca complacer a cada instante, sino un compañero que elige forjar un vínculo basado en el respeto y la confianza mutua.
                        </p>
                        <p class="mb-3">
                            Lejos de ser distante, el Shiba es profundamente devoto a su círculo íntimo. Su lealtad es un lazo invisible pero inquebrantable. Es un perro de una pulcritud casi felina, que disfruta de la limpieza y el orden. Posee una energía vibrante y una calma serena que lo hace perfecto tanto para caminatas por el bosque como para acurrucarse en casa.
                        </p>
                        <p class="mb-0 fst-italic">
                            Criar un Shiba Inu es invitar a tu vida a un ser de una inteligencia aguda, una belleza innegable y un espíritu valiente. Es un compañero para aquellos que aprecian la independencia y valoran la lealtad sincera.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!--  -->
    <!-- Cachorros Disponibles -->
    <!-- <section id="cachorros" class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="display-5 fw-bold">Nuestros Productos Disponibles</h2>
            </div>
            <div class="row g-4">

                <? //php echo listado_inicial2($link, $codigo); 
                ?>

            </div>
        </div>
    </section> -->

    <!-- Cachorros Disponibles -->
    <section id="cachorros" class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="display-5 fw-bold">Nuestros Shiba Inu Disponibles</h2>
                <p class="lead">Conoce a los Shiba Inu listos para integrarse a una familia responsable.
                    Cada cachorro tiene fotos, video, temperamento inicial y detalles de sus padres.</p>
            </div>
            <div class="row g-4">

                <?php echo listado_inicial($link, $codigo); ?>

            </div>
            <div class="text-center mt-5">
                <a href="<?= $_SESSION["url_ruta"] ?>/tienda" class="btn btn-primary btn-lg">Ver todos los cachorros</a>
            </div>
        </div>
    </section>

    <!-- Proceso -->
    <section class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="display-5 fw-bold">Nuestro Proceso de Selección y Entrega</h2>
                <p class="lead">Simple, transparente y profesional</p>
            </div>
            <div class="row g-4">
                <div class="col-md-6 col-lg-4">
                    <div class="text-center">
                        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center"
                            style="width: 60px; height: 60px;">
                            <span class="h4 mb-0">1</span>
                        </div>
                        <h4 class="mt-3">Primer contacto</h4>
                        <p>WhatsApp, SMS o llamada. Resolución de dudas.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="text-center">
                        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center"
                            style="width: 60px; height: 60px;">
                            <span class="h4 mb-0">2</span>
                        </div>
                        <h4 class="mt-3">Explora nuestros cachorros</h4>
                        <p>Consulta fotos, videos y temperamentos.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="text-center">
                        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center"
                            style="width: 60px; height: 60px;">
                            <span class="h4 mb-0">3</span>
                        </div>
                        <h4 class="mt-3">Videollamada personalizada</h4>
                        <p>Conoce al cachorro en tiempo real.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="text-center">
                        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center"
                            style="width: 60px; height: 60px;">
                            <span class="h4 mb-0">4</span>
                        </div>
                        <h4 class="mt-3">Apartado y logística</h4>
                        <p>Agendamos fecha, lugar y transporte seguro.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="text-center">
                        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center"
                            style="width: 60px; height: 60px;">
                            <span class="h4 mb-0">5</span>
                        </div>
                        <h4 class="mt-3">Documentación completa</h4>
                        <p>Cartilla, historial y carnet listos.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="text-center">
                        <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center"
                            style="width: 60px; height: 60px;">
                            <span class="h4 mb-0">6</span>
                        </div>
                        <h4 class="mt-3">Métodos de pago</h4>
                        <p>Tarjeta, transferencia o efectivo.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonios -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="display-5 fw-bold">Familias que ya viven con un Shiba Inu de Shibainu Met</h2>
            </div>
            <div class="row g-4">
                <div class="col-lg-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body p-4">
                            <div class="mb-3">
                                <i class="bi bi-star-fill text-warning"></i>
                                <i class="bi bi-star-fill text-warning"></i>
                                <i class="bi bi-star-fill text-warning"></i>
                                <i class="bi bi-star-fill text-warning"></i>
                                <i class="bi bi-star-fill text-warning"></i>
                            </div>
                            <p class="card-text">"La experiencia fue transparente y llena de acompañamiento."</p>
                            <div class="d-flex align-items-center">
                                <img src="https://i.pravatar.cc/50?img=1" class="rounded-circle me-3" alt="María">
                                <div>
                                    <h6 class="mb-0">María G.</h6>
                                    <small class="text-muted">CDMX</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body p-4">
                            <div class="mb-3">
                                <i class="bi bi-star-fill text-warning"></i>
                                <i class="bi bi-star-fill text-warning"></i>
                                <i class="bi bi-star-fill text-warning"></i>
                                <i class="bi bi-star-fill text-warning"></i>
                                <i class="bi bi-star-fill text-warning"></i>
                            </div>
                            <p class="card-text">"Nuestro Shiba llegó sano, hermoso y perfectamente socializado."</p>
                            <div class="d-flex align-items-center">
                                <img src="https://i.pravatar.cc/50?img=3" class="rounded-circle me-3" alt="Fabián">
                                <div>
                                    <h6 class="mb-0">Fabián R.</h6>
                                    <small class="text-muted">Querétaro</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body p-4">
                            <div class="mb-3">
                                <i class="bi bi-star-fill text-warning"></i>
                                <i class="bi bi-star-fill text-warning"></i>
                                <i class="bi bi-star-fill text-warning"></i>
                                <i class="bi bi-star-fill text-warning"></i>
                                <i class="bi bi-star-fill text-warning"></i>
                            </div>
                            <p class="card-text">"La videollamada nos dio total confianza. Excelente trato."</p>
                            <div class="d-flex align-items-center">
                                <img src="https://i.pravatar.cc/50?img=5" class="rounded-circle me-3" alt="Sandra">
                                <div>
                                    <h6 class="mb-0">Sandra y Luis</h6>
                                    <small class="text-muted">Guadalajara</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Servicios Adicionales -->
    <section id="servicios" class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="display-5 fw-bold">Acompañamiento Integral para tu Shiba Inu</h2>
            </div>
            <div class="row g-4">
                <div class="col-md-6 col-lg-4">
                    <div class="text-center">
                        <i class="bi bi-mortarboard display-1 text-primary"></i>
                        <h4 class="mt-3">Entrenamiento personalizado</h4>
                        <p>Programas adaptados a tu Shiba</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="text-center">
                        <i class="bi bi-house-heart display-1 text-primary"></i>
                        <h4 class="mt-3">Pensión y guardería</h4>
                        <p>Cuidado profesional cuando lo necesites</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="text-center">
                        <i class="bi bi-hospital display-1 text-primary"></i>
                        <h4 class="mt-3">Veterinaria especializada</h4>
                        <p>Expertos en la raza Shiba Inu</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="text-center">
                        <i class="bi bi-tree display-1 text-primary"></i>
                        <h4 class="mt-3">Actividades recreativas</h4>
                        <p>Caminatas y socialización</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="text-center">
                        <i class="bi bi-bag-heart display-1 text-primary"></i>
                        <h4 class="mt-3">Tienda especializada</h4>
                        <p>Alimento y accesorios premium</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="text-center">
                        <i class="bi bi-truck display-1 text-primary"></i>
                        <h4 class="mt-3">Envíos nacionales</h4>
                        <p>Entrega segura en todo México</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- CTA Relocalización Shiba Inu -->
<section class="py-5 bg-light" id="relocalizacion">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <a href="https://www.trabajo.podermail.org/shiba/#relocalizacion"
                   class="text-decoration-none text-dark">
                    <div class="card border-0 shadow-lg">
                        <div class="card-body p-5">
                            <div class="text-center mb-4">
                                <i class="bi bi-heart-pulse display-4 text-primary mb-3"></i>
                                <h3 class="fw-bold">Relocalización</h3>
                            </div>

                            <p class="lead text-center mb-4">
                                Si estás interesado en que te ayudemos a relocalizar tu Shiba Inu
                                o deseas adoptar uno mediante un donativo responsable,
                                ponte en contacto con nosotros vía WhatsApp para brindarte acompañamiento
                                profesional y ético.
                            </p>

                            <div class="row justify-content-center">
                                <div class="col-md-8">
                                    <h5 class="fw-bold mb-3 text-center">Servicios adicionales</h5>
                                    <ul class="list-unstyled">
                                        <li class="mb-2">
                                            <i class="bi bi-check-circle-fill text-primary me-2"></i>
                                            Entrenamiento personalizado
                                        </li>
                                        <li class="mb-2">
                                            <i class="bi bi-check-circle-fill text-primary me-2"></i>
                                            Pensión y guardería
                                        </li>
                                        <li class="mb-2">
                                            <i class="bi bi-check-circle-fill text-primary me-2"></i>
                                            Veterinaria especializada en Shiba Inu
                                        </li>
                                        <li class="mb-2">
                                            <i class="bi bi-check-circle-fill text-primary me-2"></i>
                                            Actividades recreativas (caminatas y socialización)
                                        </li>
                                        <li class="mb-2">
                                            <i class="bi bi-check-circle-fill text-primary me-2"></i>
                                            Tienda de alimento y accesorios
                                        </li>
                                    </ul>
                                </div>
                            </div>
                                </span>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        </div>
    </div>
</section>

    <!-- CTA Final -->
    <section class="py-5 bg-primary text-white">
        <div class="container text-center">
            <h2 class="display-5 fw-bold mb-4">¿Listo para conocer a tu próximo compañero?</h2>
            <p class="lead mb-4">Agenda una videollamada hoy mismo y conoce a nuestros Shiba Inu disponibles</p>
            <div class="d-flex flex-wrap gap-3 justify-content-center">
                <a href="https://wa.me/5215561077466" class="btn btn-success btn-lg px-4 py-3">
                    <i class="bi bi-whatsapp"></i> Contactar por WhatsApp
                </a>
                <a href="tel:5561077466" class="btn btn-light btn-lg px-4 py-3">
                    <i class="bi bi-telephone"></i> Llamar ahora
                </a>
            </div>
        </div>
    </section>

    <? include("_integra/include/footer.php"); ?>

</body>

</html>