<?php
// --- CONFIGURACIÓN ---

// 1. Incluye tu archivo de conexión a la base de datos.
//    Asegúrate de que la ruta sea correcta. Este archivo debe definir la variable $link.
include("_integra/include/conn.php");

// 2. Define los valores con los que quieres probar la consulta.
//    Cambia estos números por los IDs que quieres verificar.
$id_usuario_a_probar = 1; // Reemplaza 1 con un ID de usuario válido para la prueba
$id_slider_a_probar = 896; // El ID del slider que estás intentando cargar

// --- FIN DE LA CONFIGURACIÓN ---


// Imprime un encabezado para que la salida sea clara
header('Content-Type: text/plain; charset=utf-8');
echo "--- Iniciando script de diagnóstico para el slider ---\n\n";

// Verifica si la conexión a la BD existe y es válida
if (!isset($link) || mysqli_connect_errno()) {
    die("Error: No se pudo establecer la conexión a la base de datos. Revisa tu archivo de conexión.");
}

echo "Conexión a la base de datos establecida correctamente.\n\n";

// Prepara la consulta usando los valores de prueba
$query = "
	SELECT * FROM blogdet WHERE cve_sysusuario = 1666
";

echo "Ejecutando la siguiente consulta:\n";
echo "---------------------------------\n";
echo $query;
echo "\n---------------------------------\n\n";

// Ejecuta la consulta
$resultado = @mysqli_query($link, $query);

// Verifica si hubo un error en la consulta
if (!$resultado) {
    echo "¡ERROR EN LA CONSULTA SQL!\n";
    echo "Mensaje de error: " . mysqli_error($link);
    die();
}

// Verifica cuántas filas se encontraron
$numero_de_filas = mysqli_num_rows($resultado);

if ($numero_de_filas > 0) {
    echo "¡Éxito! La consulta devolvió " . $numero_de_filas . " fila(s).\n\n";
    echo "Datos encontrados:\n";
    $contador = 1;
    // Itera sobre los resultados y los imprime
    while ($fila = mysqli_fetch_assoc($resultado)) {
        echo "\n--- Fila " . $contador++ . " ---\n";
        print_r($fila);
    }
} else {
    echo "La consulta se ejecutó correctamente, pero no se encontró ninguna fila que coincida con los criterios.\n";
    echo "Posibles razones:\n";
    echo "- El ID de slider (" . $id_slider_a_probar . ") no tiene elementos activos.\n";
    echo "- El ID de usuario (" . $id_usuario_a_probar . ") no tiene permiso para ver estos elementos.\n";
    echo "- Los elementos o el slider principal tienen un status (cve_statuscat) diferente de 1.\n";
}

// Cierra la conexión
@mysqli_close($link);

echo "\n--- Fin del script de diagnóstico ---";

?>